"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class NodeInfoV2TypedDict(TypedDict):
    decimals: NotRequired[int]
    features: NotRequired[Nullable[List[str]]]
    is_healthy: NotRequired[bool]
    latest_milestone: NotRequired[int]
    latest_uncommitted_milestone: NotRequired[int]
    name: NotRequired[str]
    network_name: NotRequired[str]
    protocol_version: NotRequired[int]
    subunit: NotRequired[str]
    supported_protocol_versions: NotRequired[Nullable[List[int]]]
    ticker_symbol: NotRequired[str]
    token_name: NotRequired[str]
    token_supply: NotRequired[str]
    unit: NotRequired[str]
    version: NotRequired[str]


class NodeInfoV2(BaseModel):
    decimals: Optional[int] = None

    features: OptionalNullable[List[str]] = UNSET

    is_healthy: Optional[bool] = None

    latest_milestone: Optional[int] = None

    latest_uncommitted_milestone: Optional[int] = None

    name: Optional[str] = None

    network_name: Optional[str] = None

    protocol_version: Optional[int] = None

    subunit: Optional[str] = None

    supported_protocol_versions: OptionalNullable[List[int]] = UNSET

    ticker_symbol: Optional[str] = None

    token_name: Optional[str] = None

    token_supply: Optional[str] = None

    unit: Optional[str] = None

    version: Optional[str] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "decimals",
            "features",
            "is_healthy",
            "latest_milestone",
            "latest_uncommitted_milestone",
            "name",
            "network_name",
            "protocol_version",
            "subunit",
            "supported_protocol_versions",
            "ticker_symbol",
            "token_name",
            "token_supply",
            "unit",
            "version",
        ]
        nullable_fields = ["features", "supported_protocol_versions"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
