"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class NetworkTypedDict(TypedDict):
    allocation_type: NotRequired[str]
    cidrs: NotRequired[Nullable[List[str]]]
    r"""A set of CIDRs describing the range."""
    created: NotRequired[str]
    handle: NotRequired[str]
    name: NotRequired[str]
    updated: NotRequired[str]


class Network(BaseModel):
    allocation_type: Optional[str] = None

    cidrs: OptionalNullable[List[str]] = UNSET
    r"""A set of CIDRs describing the range."""

    created: Optional[str] = None

    handle: Optional[str] = None

    name: Optional[str] = None

    updated: Optional[str] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "allocation_type",
            "cidrs",
            "created",
            "handle",
            "name",
            "updated",
        ]
        nullable_fields = ["cidrs"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
