"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .distinguishedname import DistinguishedName, DistinguishedNameTypedDict
from .edipartyname import EdiPartyName, EdiPartyNameTypedDict
from .generalsubtreeip import GeneralSubtreeIP, GeneralSubtreeIPTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class NameConstraintsTypedDict(TypedDict):
    critical: NotRequired[bool]
    excluded_directory_names: NotRequired[Nullable[List[DistinguishedNameTypedDict]]]
    r"""A record providing excluded names of the type directoryName in leaf certificates whose trust path includes this certificate."""
    excluded_edi_party_names: NotRequired[Nullable[List[EdiPartyNameTypedDict]]]
    r"""A record providing excluded names of the type ediPartyName in leaf certificates whose trust path includes this certificate."""
    excluded_email_addresses: NotRequired[Nullable[List[str]]]
    r"""A record providing a range of excluded names of the type rfc822Name in leaf certificates whose trust path includes this certificate."""
    excluded_ip_addresses: NotRequired[Nullable[List[GeneralSubtreeIPTypedDict]]]
    r"""A record providing a range of excluded names of the type iPAddress in leaf certificates whose trust path includes this certificate."""
    excluded_names: NotRequired[Nullable[List[str]]]
    r"""A record providing a range of excluded names of the type dNSName in leaf certificates whose trust path includes this certificate."""
    excluded_registered_ids: NotRequired[Nullable[List[str]]]
    r"""A record providing excluded names of the type registeredID in leaf certificates whose trust path includes this certificate."""
    excluded_uris: NotRequired[Nullable[List[str]]]
    r"""A record providing a range of excluded uniform resource identifiers in leaf certificates whose trust path includes this certificate."""
    permitted_directory_names: NotRequired[Nullable[List[DistinguishedNameTypedDict]]]
    r"""A record providing permitted names of the type directoryName in leaf certificates whose trust path includes this certificate."""
    permitted_edi_party_names: NotRequired[Nullable[List[EdiPartyNameTypedDict]]]
    r"""A record providing permitted names of the type ediPartyName in leaf certificates whose trust path includes this certificate."""
    permitted_email_addresses: NotRequired[Nullable[List[str]]]
    r"""A record providing a range of permitted names of the type rfc822Name in leaf certificates whose trust path includes this certificate."""
    permitted_ip_addresses: NotRequired[Nullable[List[GeneralSubtreeIPTypedDict]]]
    r"""A record providing a range of permitted names of the type iPAddress in leaf certificates whose trust path includes this certificate."""
    permitted_names: NotRequired[Nullable[List[str]]]
    r"""A record providing a range of permitted names of the type dNSName in leaf certificates whose trust path includes this certificate."""
    permitted_registered_ids: NotRequired[Nullable[List[str]]]
    r"""A record providing permitted names of the type registeredID in leaf certificates whose trust path includes this certificate."""
    permitted_uris: NotRequired[Nullable[List[str]]]
    r"""A record providing a range of permitted uniform resource identifiers in leaf certificates whose trust path includes this certificate."""


class NameConstraints(BaseModel):
    critical: Optional[bool] = None

    excluded_directory_names: OptionalNullable[List[DistinguishedName]] = UNSET
    r"""A record providing excluded names of the type directoryName in leaf certificates whose trust path includes this certificate."""

    excluded_edi_party_names: OptionalNullable[List[EdiPartyName]] = UNSET
    r"""A record providing excluded names of the type ediPartyName in leaf certificates whose trust path includes this certificate."""

    excluded_email_addresses: OptionalNullable[List[str]] = UNSET
    r"""A record providing a range of excluded names of the type rfc822Name in leaf certificates whose trust path includes this certificate."""

    excluded_ip_addresses: OptionalNullable[List[GeneralSubtreeIP]] = UNSET
    r"""A record providing a range of excluded names of the type iPAddress in leaf certificates whose trust path includes this certificate."""

    excluded_names: OptionalNullable[List[str]] = UNSET
    r"""A record providing a range of excluded names of the type dNSName in leaf certificates whose trust path includes this certificate."""

    excluded_registered_ids: OptionalNullable[List[str]] = UNSET
    r"""A record providing excluded names of the type registeredID in leaf certificates whose trust path includes this certificate."""

    excluded_uris: OptionalNullable[List[str]] = UNSET
    r"""A record providing a range of excluded uniform resource identifiers in leaf certificates whose trust path includes this certificate."""

    permitted_directory_names: OptionalNullable[List[DistinguishedName]] = UNSET
    r"""A record providing permitted names of the type directoryName in leaf certificates whose trust path includes this certificate."""

    permitted_edi_party_names: OptionalNullable[List[EdiPartyName]] = UNSET
    r"""A record providing permitted names of the type ediPartyName in leaf certificates whose trust path includes this certificate."""

    permitted_email_addresses: OptionalNullable[List[str]] = UNSET
    r"""A record providing a range of permitted names of the type rfc822Name in leaf certificates whose trust path includes this certificate."""

    permitted_ip_addresses: OptionalNullable[List[GeneralSubtreeIP]] = UNSET
    r"""A record providing a range of permitted names of the type iPAddress in leaf certificates whose trust path includes this certificate."""

    permitted_names: OptionalNullable[List[str]] = UNSET
    r"""A record providing a range of permitted names of the type dNSName in leaf certificates whose trust path includes this certificate."""

    permitted_registered_ids: OptionalNullable[List[str]] = UNSET
    r"""A record providing permitted names of the type registeredID in leaf certificates whose trust path includes this certificate."""

    permitted_uris: OptionalNullable[List[str]] = UNSET
    r"""A record providing a range of permitted uniform resource identifiers in leaf certificates whose trust path includes this certificate."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "critical",
            "excluded_directory_names",
            "excluded_edi_party_names",
            "excluded_email_addresses",
            "excluded_ip_addresses",
            "excluded_names",
            "excluded_registered_ids",
            "excluded_uris",
            "permitted_directory_names",
            "permitted_edi_party_names",
            "permitted_email_addresses",
            "permitted_ip_addresses",
            "permitted_names",
            "permitted_registered_ids",
            "permitted_uris",
        ]
        nullable_fields = [
            "excluded_directory_names",
            "excluded_edi_party_names",
            "excluded_email_addresses",
            "excluded_ip_addresses",
            "excluded_names",
            "excluded_registered_ids",
            "excluded_uris",
            "permitted_directory_names",
            "permitted_edi_party_names",
            "permitted_email_addresses",
            "permitted_ip_addresses",
            "permitted_names",
            "permitted_registered_ids",
            "permitted_uris",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
