"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from censys_platform.types import BaseModel
from typing import Dict, Optional
from typing_extensions import NotRequired, TypedDict


class MysqlTypedDict(TypedDict):
    auth_plugin_data: NotRequired[str]
    r"""Optional plugin-specific data, whose meaning depends on the value of auth_plugin_name. Returned in the initial HandshakePacket."""
    auth_plugin_name: NotRequired[str]
    r"""The name of the authentication plugin, returned in the initial HandshakePacket."""
    capability_flags: NotRequired[Dict[str, bool]]
    r"""The set of capability flags the server returned in the initial HandshakePacket. Each entry corresponds to a bit being set in the flags; key names correspond to the #defines in the MySQL docs."""
    character_set: NotRequired[int]
    r"""The identifier for the character set the server is using. Returned in the initial HandshakePacket."""
    connection_id: NotRequired[int]
    r"""The server's internal identifier for this client's connection, sent in the initial HandshakePacket."""
    error_code: NotRequired[int]
    r"""Only set if there is an error returned by the server, for example if the scanner is not on the allowed hosts list."""
    error_id: NotRequired[str]
    r"""The friendly name for the error code as defined at https://dev.mysql.com/doc/refman/8.0/en/error-messages-server.html, or UNKNOWN"""
    error_message: NotRequired[str]
    r"""Optional string describing the error. Only set if there is an error."""
    protocol_version: NotRequired[int]
    r"""8-bit unsigned integer representing the server's protocol version sent in the initial HandshakePacket from the server."""
    server_version: NotRequired[str]
    r"""The specific server version returned in the initial HandshakePacket. Often in the form x.y.z, but not always."""
    status_flags: NotRequired[Dict[str, bool]]
    r"""The set of status flags the server returned in the initial HandshakePacket. Each entry corresponds to a bit being set in the flags; key names correspond to the #defines in the MySQL docs."""


class Mysql(BaseModel):
    auth_plugin_data: Optional[str] = None
    r"""Optional plugin-specific data, whose meaning depends on the value of auth_plugin_name. Returned in the initial HandshakePacket."""

    auth_plugin_name: Optional[str] = None
    r"""The name of the authentication plugin, returned in the initial HandshakePacket."""

    capability_flags: Optional[Dict[str, bool]] = None
    r"""The set of capability flags the server returned in the initial HandshakePacket. Each entry corresponds to a bit being set in the flags; key names correspond to the #defines in the MySQL docs."""

    character_set: Optional[int] = None
    r"""The identifier for the character set the server is using. Returned in the initial HandshakePacket."""

    connection_id: Optional[int] = None
    r"""The server's internal identifier for this client's connection, sent in the initial HandshakePacket."""

    error_code: Optional[int] = None
    r"""Only set if there is an error returned by the server, for example if the scanner is not on the allowed hosts list."""

    error_id: Optional[str] = None
    r"""The friendly name for the error code as defined at https://dev.mysql.com/doc/refman/8.0/en/error-messages-server.html, or UNKNOWN"""

    error_message: Optional[str] = None
    r"""Optional string describing the error. Only set if there is an error."""

    protocol_version: Optional[int] = None
    r"""8-bit unsigned integer representing the server's protocol version sent in the initial HandshakePacket from the server."""

    server_version: Optional[str] = None
    r"""The specific server version returned in the initial HandshakePacket. Often in the form x.y.z, but not always."""

    status_flags: Optional[Dict[str, bool]] = None
    r"""The set of status flags the server returned in the initial HandshakePacket. Each entry corresponds to a bit being set in the flags; key names correspond to the #defines in the MySQL docs."""
