"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .coordinates import Coordinates, CoordinatesTypedDict
from censys_platform.types import BaseModel
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class LocationTypedDict(TypedDict):
    city: NotRequired[str]
    r"""The English name of the detected city."""
    continent: NotRequired[str]
    r"""The English name of the detected continent (North America, Europe, Asia, South America, Africa, Oceania, Antarctica)."""
    coordinates: NotRequired[CoordinatesTypedDict]
    country: NotRequired[str]
    r"""The English name of the detected country."""
    country_code: NotRequired[str]
    r"""The detected two-letter ISO 3166-1 alpha-2 country code (US, CN, GB, RU, ...)."""
    postal_code: NotRequired[str]
    r"""The postal code (if applicable) of the detected location."""
    province: NotRequired[str]
    r"""The state or province name of the detected location."""
    registered_country: NotRequired[str]
    r"""The English name of the registered country."""
    registered_country_code: NotRequired[str]
    r"""The registered country's two-letter ISO 3166-1 alpha-2 country code (US, CN, GB, RU, ...)."""
    timezone: NotRequired[str]
    r"""The IANA time zone database name of the detected location."""


class Location(BaseModel):
    city: Optional[str] = None
    r"""The English name of the detected city."""

    continent: Optional[str] = None
    r"""The English name of the detected continent (North America, Europe, Asia, South America, Africa, Oceania, Antarctica)."""

    coordinates: Optional[Coordinates] = None

    country: Optional[str] = None
    r"""The English name of the detected country."""

    country_code: Optional[str] = None
    r"""The detected two-letter ISO 3166-1 alpha-2 country code (US, CN, GB, RU, ...)."""

    postal_code: Optional[str] = None
    r"""The postal code (if applicable) of the detected location."""

    province: Optional[str] = None
    r"""The state or province name of the detected location."""

    registered_country: Optional[str] = None
    r"""The English name of the registered country."""

    registered_country_code: Optional[str] = None
    r"""The registered country's two-letter ISO 3166-1 alpha-2 country code (US, CN, GB, RU, ...)."""

    timezone: Optional[str] = None
    r"""The IANA time zone database name of the detected location."""
