"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .ldap_attribute import LdapAttribute, LdapAttributeTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class LdapTypedDict(TypedDict):
    allows_anonymous_bind: NotRequired[bool]
    r"""Ability to connect with anonymous bind (empty username and password)"""
    attributes: NotRequired[Nullable[List[LdapAttributeTypedDict]]]
    r"""All root DN attributes available via anonymous bind"""
    result_code: NotRequired[int]
    r"""Result or error code returned by LDAP instance upon bind"""


class Ldap(BaseModel):
    allows_anonymous_bind: Optional[bool] = None
    r"""Ability to connect with anonymous bind (empty username and password)"""

    attributes: OptionalNullable[List[LdapAttribute]] = UNSET
    r"""All root DN attributes available via anonymous bind"""

    result_code: Optional[int] = None
    r"""Result or error code returned by LDAP instance upon bind"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["allows_anonymous_bind", "attributes", "result_code"]
        nullable_fields = ["attributes"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
