"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .evidence import Evidence, EvidenceTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class LabelSource(str, Enum):
    UNKNOWN = ""
    CENSYS = "censys"
    RECOG = "recog"
    WAPPALYZER = "wappalyzer"
    THIRD_PARTY = "third_party"


class LabelTypedDict(TypedDict):
    confidence: NotRequired[float]
    evidence: NotRequired[Nullable[List[EvidenceTypedDict]]]
    source: NotRequired[LabelSource]
    value: NotRequired[str]


class Label(BaseModel):
    confidence: Optional[float] = None

    evidence: OptionalNullable[List[Evidence]] = UNSET

    source: Optional[LabelSource] = None

    value: Optional[str] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["confidence", "evidence", "source", "value"]
        nullable_fields = ["evidence"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
