"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List
from typing_extensions import NotRequired, TypedDict


class KubernetesRoleRuleTypedDict(TypedDict):
    api_groups: NotRequired[Nullable[List[str]]]
    r"""APIGroups is the name of the APIGroup that contains the resources. If multiple API groups are specified, any action requested against one of the enumerated resources in any API group will be allowed."""
    resources: NotRequired[Nullable[List[str]]]
    r"""Resources is a list of resources this rule applies to. ResourceAll represents all resources"""
    verbs: NotRequired[Nullable[List[str]]]
    r"""Verbs is a list of Verbs that apply to ALL the ResourceKinds and AttributeRestrictions contained in this rule. VerbAll represents all kinds."""


class KubernetesRoleRule(BaseModel):
    api_groups: OptionalNullable[List[str]] = UNSET
    r"""APIGroups is the name of the APIGroup that contains the resources. If multiple API groups are specified, any action requested against one of the enumerated resources in any API group will be allowed."""

    resources: OptionalNullable[List[str]] = UNSET
    r"""Resources is a list of resources this rule applies to. ResourceAll represents all resources"""

    verbs: OptionalNullable[List[str]] = UNSET
    r"""Verbs is a list of Verbs that apply to ALL the ResourceKinds and AttributeRestrictions contained in this rule. VerbAll represents all kinds."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["api_groups", "resources", "verbs"]
        nullable_fields = ["api_groups", "resources", "verbs"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
