"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .kubernetes_node_nodeaddress import (
    KubernetesNodeNodeAddress,
    KubernetesNodeNodeAddressTypedDict,
)
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class KubernetesNodeTypedDict(TypedDict):
    addresses: NotRequired[Nullable[List[KubernetesNodeNodeAddressTypedDict]]]
    architecture: NotRequired[str]
    r"""The Architecture reported by the node."""
    container_runtime_version: NotRequired[str]
    r"""ContainerRuntime Version reported by the node through runtime remote API (e.g. docker://1.5.0)."""
    images: NotRequired[Nullable[List[str]]]
    r"""List of container images on this node"""
    kernel_version: NotRequired[str]
    r"""Kernel Version reported by the node from 'uname -r' (e.g. 3.16.0-0.bpo.4-amd64)."""
    kube_proxy_version: NotRequired[str]
    r"""KubeProxy Version reported by the node."""
    kubelet_version: NotRequired[str]
    r"""Kubelet Version reported by the node."""
    name: NotRequired[str]
    operating_system: NotRequired[str]
    r"""The Operating System reported by the node."""
    os_image: NotRequired[str]
    r"""OS Image reported by the node from /etc/os-release (e.g. Debian GNU/Linux 7 (wheezy))."""


class KubernetesNode(BaseModel):
    addresses: OptionalNullable[List[KubernetesNodeNodeAddress]] = UNSET

    architecture: Optional[str] = None
    r"""The Architecture reported by the node."""

    container_runtime_version: Optional[str] = None
    r"""ContainerRuntime Version reported by the node through runtime remote API (e.g. docker://1.5.0)."""

    images: OptionalNullable[List[str]] = UNSET
    r"""List of container images on this node"""

    kernel_version: Optional[str] = None
    r"""Kernel Version reported by the node from 'uname -r' (e.g. 3.16.0-0.bpo.4-amd64)."""

    kube_proxy_version: Optional[str] = None
    r"""KubeProxy Version reported by the node."""

    kubelet_version: Optional[str] = None
    r"""Kubelet Version reported by the node."""

    name: Optional[str] = None

    operating_system: Optional[str] = None
    r"""The Operating System reported by the node."""

    os_image: Optional[str] = None
    r"""OS Image reported by the node from /etc/os-release (e.g. Debian GNU/Linux 7 (wheezy))."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "addresses",
            "architecture",
            "container_runtime_version",
            "images",
            "kernel_version",
            "kube_proxy_version",
            "kubelet_version",
            "name",
            "operating_system",
            "os_image",
        ]
        nullable_fields = ["addresses", "images"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
