"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from censys_platform.types import BaseModel
from enum import Enum
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class KEVSource(str, Enum):
    r"""The source checked to determine whether the CVE is in the KEV catalog."""

    UNKNOWN = ""
    CISA = "cisa"
    THIRD_PARTY = "third_party"


class KevTypedDict(TypedDict):
    date_added: NotRequired[str]
    r"""The date the vulnerability was added to the KEV catalog."""
    date_due: NotRequired[str]
    r"""Per CISA’s Binding Operation Directive 22-01, the date all federal civilian executive branch (FCEB) agencies are required to remediate vulnerabilities in the KEV catalog."""
    source: NotRequired[KEVSource]
    r"""The source checked to determine whether the CVE is in the KEV catalog."""


class Kev(BaseModel):
    date_added: Optional[str] = None
    r"""The date the vulnerability was added to the KEV catalog."""

    date_due: Optional[str] = None
    r"""Per CISA’s Binding Operation Directive 22-01, the date all federal civilian executive branch (FCEB) agencies are required to remediate vulnerabilities in the KEV catalog."""

    source: Optional[KEVSource] = None
    r"""The source checked to determine whether the CVE is in the KEV catalog."""
