"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from censys_platform.types import BaseModel
from enum import Enum
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class JarmScanTransportProtocol(str, Enum):
    UNKNOWN = ""
    TCP = "tcp"
    UDP = "udp"
    ICMP = "icmp"
    QUIC = "quic"


class JarmScanTypedDict(TypedDict):
    cipher_and_version_fingerprint: NotRequired[str]
    r"""The first 30 character portion of the Jarm fingerprint."""
    fingerprint: NotRequired[str]
    r"""The 62 character Jarm fingerprint of the service."""
    hostname: NotRequired[str]
    ip: NotRequired[str]
    is_success: NotRequired[bool]
    port: NotRequired[int]
    scan_time: NotRequired[str]
    r"""The time the service was fingerprinted"""
    tls_extensions_sha256: NotRequired[str]
    r"""The second 32 character portion of the Jarm fingerprint"""
    transport_protocol: NotRequired[JarmScanTransportProtocol]


class JarmScan(BaseModel):
    cipher_and_version_fingerprint: Optional[str] = None
    r"""The first 30 character portion of the Jarm fingerprint."""

    fingerprint: Optional[str] = None
    r"""The 62 character Jarm fingerprint of the service."""

    hostname: Optional[str] = None

    ip: Optional[str] = None

    is_success: Optional[bool] = None

    port: Optional[int] = None

    scan_time: Optional[str] = None
    r"""The time the service was fingerprinted"""

    tls_extensions_sha256: Optional[str] = None
    r"""The second 32 character portion of the Jarm fingerprint"""

    transport_protocol: Optional[JarmScanTransportProtocol] = None
