"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .ipp_attribute import IppAttribute, IppAttributeTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class IppTypedDict(TypedDict):
    attribute_cups_version: NotRequired[str]
    r"""The CUPS version, if any, specified in the list of attributes returned in a get-printer-attributes response or CUPS-get-printers response. Generally in the form 'x.y.z'."""
    attribute_ipp_versions: NotRequired[Nullable[List[str]]]
    r"""Each IPP version, if any, specified in the list of attributes returned in a get-printer-attributes response or CUPS-get-printers response. Always in the form 'x.y'."""
    attribute_printer_uris: NotRequired[Nullable[List[str]]]
    r"""Each printer URI, if any, specified in the list of attributes returned in a get-printer-attributes response or CUPS-get-printers response. Uses ipp(s) or http(s) scheme, followed by a hostname or IP, and then the path to a particular printer."""
    attributes: NotRequired[Nullable[List[IppAttributeTypedDict]]]
    r"""All IPP attributes included in any contentful responses obtained. Each has a name, list of values (potentially only one), and a tag denoting how the value should be interpreted."""
    cups_version: NotRequired[str]
    r"""The CUPS version, if any, specified in the Server header of an IPP get-attributes response."""
    major_version: NotRequired[int]
    r"""Major component of IPP version listed in the Server header of a response to an IPP get-printer-attributes request."""
    minor_version: NotRequired[int]
    r"""Minor component of IPP version listed in the Server header of a response to an IPP get-printer-attributes request."""
    version_string: NotRequired[str]
    r"""The specific IPP version returned in response to an IPP get-printer-attributes request. Always in the form 'IPP/x.y'"""


class Ipp(BaseModel):
    attribute_cups_version: Optional[str] = None
    r"""The CUPS version, if any, specified in the list of attributes returned in a get-printer-attributes response or CUPS-get-printers response. Generally in the form 'x.y.z'."""

    attribute_ipp_versions: OptionalNullable[List[str]] = UNSET
    r"""Each IPP version, if any, specified in the list of attributes returned in a get-printer-attributes response or CUPS-get-printers response. Always in the form 'x.y'."""

    attribute_printer_uris: OptionalNullable[List[str]] = UNSET
    r"""Each printer URI, if any, specified in the list of attributes returned in a get-printer-attributes response or CUPS-get-printers response. Uses ipp(s) or http(s) scheme, followed by a hostname or IP, and then the path to a particular printer."""

    attributes: OptionalNullable[List[IppAttribute]] = UNSET
    r"""All IPP attributes included in any contentful responses obtained. Each has a name, list of values (potentially only one), and a tag denoting how the value should be interpreted."""

    cups_version: Optional[str] = None
    r"""The CUPS version, if any, specified in the Server header of an IPP get-attributes response."""

    major_version: Optional[int] = None
    r"""Major component of IPP version listed in the Server header of a response to an IPP get-printer-attributes request."""

    minor_version: Optional[int] = None
    r"""Minor component of IPP version listed in the Server header of a response to an IPP get-printer-attributes request."""

    version_string: Optional[str] = None
    r"""The specific IPP version returned in response to an IPP get-printer-attributes request. Always in the form 'IPP/x.y'"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "attribute_cups_version",
            "attribute_ipp_versions",
            "attribute_printer_uris",
            "attributes",
            "cups_version",
            "major_version",
            "minor_version",
            "version_string",
        ]
        nullable_fields = [
            "attribute_ipp_versions",
            "attribute_printer_uris",
            "attributes",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
