"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class IkeV1TypedDict(TypedDict):
    accepted_proposal: NotRequired[bool]
    r"""Did the host accept our security proposal? When false, the host responded with an error."""
    notify_message_types: NotRequired[Nullable[List[int]]]
    r"""Which types of NOTIFY messages did the host send us?"""
    vendor_ids: NotRequired[Nullable[List[str]]]
    r"""The list of Vendor ID \"extensions\" the host claimed to support in its handshake"""


class IkeV1(BaseModel):
    accepted_proposal: Optional[bool] = None
    r"""Did the host accept our security proposal? When false, the host responded with an error."""

    notify_message_types: OptionalNullable[List[int]] = UNSET
    r"""Which types of NOTIFY messages did the host send us?"""

    vendor_ids: OptionalNullable[List[str]] = UNSET
    r"""The list of Vendor ID \"extensions\" the host claimed to support in its handshake"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["accepted_proposal", "notify_message_types", "vendor_ids"]
        nullable_fields = ["notify_message_types", "vendor_ids"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
