"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .http_favicon import HTTPFavicon, HTTPFaviconTypedDict
from .http_repeatedheaders import HTTPRepeatedHeaders, HTTPRepeatedHeadersTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import Dict, List, Optional
from typing_extensions import NotRequired, TypedDict


class HTTPTypedDict(TypedDict):
    body: NotRequired[str]
    r"""The body of the HTTP response. For hosts without a name, the first 64KB are available. For hosts with a name, only 6KB are available."""
    body_hash_sha1: NotRequired[str]
    body_hash_sha256: NotRequired[str]
    body_hash_tlsh: NotRequired[str]
    body_size: NotRequired[int]
    r"""The length, in bytes, of services.http.response.body; at most, 64KB."""
    favicons: NotRequired[Nullable[List[HTTPFaviconTypedDict]]]
    headers: NotRequired[Dict[str, HTTPRepeatedHeadersTypedDict]]
    r"""The key-value header pairs included in the response."""
    html_tags: NotRequired[Nullable[List[str]]]
    r"""A list of the <title> and <meta> tags from services.http.response.body."""
    html_title: NotRequired[str]
    r"""The title of the HTML page: the inner contents of the <title> tag in the response body, if present."""
    protocol: NotRequired[str]
    r"""The protocol field of the response, which includes the claimed HTTP version number."""
    status_code: NotRequired[int]
    r"""A 3-digit integer result code indicating the result of the services.http.request."""
    status_reason: NotRequired[str]
    r"""A human-readable phrase describing the status code."""
    supported_versions: NotRequired[Nullable[List[str]]]
    uri: NotRequired[str]
    r"""The full path used to make the request, which includes the scheme, host, port (when non-standard), and endpoint."""


class HTTP(BaseModel):
    body: Optional[str] = None
    r"""The body of the HTTP response. For hosts without a name, the first 64KB are available. For hosts with a name, only 6KB are available."""

    body_hash_sha1: Optional[str] = None

    body_hash_sha256: Optional[str] = None

    body_hash_tlsh: Optional[str] = None

    body_size: Optional[int] = None
    r"""The length, in bytes, of services.http.response.body; at most, 64KB."""

    favicons: OptionalNullable[List[HTTPFavicon]] = UNSET

    headers: Optional[Dict[str, HTTPRepeatedHeaders]] = None
    r"""The key-value header pairs included in the response."""

    html_tags: OptionalNullable[List[str]] = UNSET
    r"""A list of the <title> and <meta> tags from services.http.response.body."""

    html_title: Optional[str] = None
    r"""The title of the HTML page: the inner contents of the <title> tag in the response body, if present."""

    protocol: Optional[str] = None
    r"""The protocol field of the response, which includes the claimed HTTP version number."""

    status_code: Optional[int] = None
    r"""A 3-digit integer result code indicating the result of the services.http.request."""

    status_reason: Optional[str] = None
    r"""A human-readable phrase describing the status code."""

    supported_versions: OptionalNullable[List[str]] = UNSET

    uri: Optional[str] = None
    r"""The full path used to make the request, which includes the scheme, host, port (when non-standard), and endpoint."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "body",
            "body_hash_sha1",
            "body_hash_sha256",
            "body_hash_tlsh",
            "body_size",
            "favicons",
            "headers",
            "html_tags",
            "html_title",
            "protocol",
            "status_code",
            "status_reason",
            "supported_versions",
            "uri",
        ]
        nullable_fields = ["favicons", "html_tags", "supported_versions"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
