"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .attribute import Attribute, AttributeTypedDict
from .hostdns import HostDNS, HostDNSTypedDict
from .label import Label, LabelTypedDict
from .location import Location, LocationTypedDict
from .routing import Routing, RoutingTypedDict
from .service import Service, ServiceTypedDict
from .whois import Whois, WhoisTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class HostTypedDict(TypedDict):
    autonomous_system: NotRequired[RoutingTypedDict]
    dns: NotRequired[HostDNSTypedDict]
    hardware: NotRequired[AttributeTypedDict]
    ip: NotRequired[str]
    labels: NotRequired[Nullable[List[LabelTypedDict]]]
    location: NotRequired[LocationTypedDict]
    operating_system: NotRequired[AttributeTypedDict]
    service_count: NotRequired[int]
    services: NotRequired[Nullable[List[ServiceTypedDict]]]
    whois: NotRequired[WhoisTypedDict]


class Host(BaseModel):
    autonomous_system: Optional[Routing] = None

    dns: Optional[HostDNS] = None

    hardware: Optional[Attribute] = None

    ip: Optional[str] = None

    labels: OptionalNullable[List[Label]] = UNSET

    location: Optional[Location] = None

    operating_system: Optional[Attribute] = None

    service_count: Optional[int] = None

    services: OptionalNullable[List[Service]] = UNSET

    whois: Optional[Whois] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "autonomous_system",
            "dns",
            "hardware",
            "ip",
            "labels",
            "location",
            "operating_system",
            "service_count",
            "services",
            "whois",
        ]
        nullable_fields = ["labels", "services"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
