"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .distinguishedname import DistinguishedName, DistinguishedNameTypedDict
from .edipartyname import EdiPartyName, EdiPartyNameTypedDict
from .othername import OtherName, OtherNameTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List
from typing_extensions import NotRequired, TypedDict


class GeneralNamesTypedDict(TypedDict):
    directory_names: NotRequired[Nullable[List[DistinguishedNameTypedDict]]]
    r"""The parsed directoryName entries in the GeneralName."""
    dns_names: NotRequired[Nullable[List[str]]]
    r"""The parsed dNSName entries in the GeneralName."""
    edi_party_names: NotRequired[Nullable[List[EdiPartyNameTypedDict]]]
    r"""The parsed eDIPartyName entries in the GeneralName."""
    email_addresses: NotRequired[Nullable[List[str]]]
    r"""The parsed rfc822Name entries in the GeneralName."""
    ip_addresses: NotRequired[Nullable[List[str]]]
    r"""The parsed ipAddress entries in the GeneralName."""
    other_names: NotRequired[Nullable[List[OtherNameTypedDict]]]
    r"""The parsed otherName entries in the GeneralName. An arbitrary binary value identified by an OID."""
    registered_ids: NotRequired[Nullable[List[str]]]
    r"""The parsed registeredID entries in the GeneralName. Stored in dotted-decimal format."""
    uniform_resource_identifiers: NotRequired[Nullable[List[str]]]
    r"""The parsed uniformResourceIdentifier entries in the GeneralName."""


class GeneralNames(BaseModel):
    directory_names: OptionalNullable[List[DistinguishedName]] = UNSET
    r"""The parsed directoryName entries in the GeneralName."""

    dns_names: OptionalNullable[List[str]] = UNSET
    r"""The parsed dNSName entries in the GeneralName."""

    edi_party_names: OptionalNullable[List[EdiPartyName]] = UNSET
    r"""The parsed eDIPartyName entries in the GeneralName."""

    email_addresses: OptionalNullable[List[str]] = UNSET
    r"""The parsed rfc822Name entries in the GeneralName."""

    ip_addresses: OptionalNullable[List[str]] = UNSET
    r"""The parsed ipAddress entries in the GeneralName."""

    other_names: OptionalNullable[List[OtherName]] = UNSET
    r"""The parsed otherName entries in the GeneralName. An arbitrary binary value identified by an OID."""

    registered_ids: OptionalNullable[List[str]] = UNSET
    r"""The parsed registeredID entries in the GeneralName. Stored in dotted-decimal format."""

    uniform_resource_identifiers: OptionalNullable[List[str]] = UNSET
    r"""The parsed uniformResourceIdentifier entries in the GeneralName."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "directory_names",
            "dns_names",
            "edi_party_names",
            "email_addresses",
            "ip_addresses",
            "other_names",
            "registered_ids",
            "uniform_resource_identifiers",
        ]
        nullable_fields = [
            "directory_names",
            "dns_names",
            "edi_party_names",
            "email_addresses",
            "ip_addresses",
            "other_names",
            "registered_ids",
            "uniform_resource_identifiers",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
