"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .status import Status, StatusTypedDict
from .worker import Worker, WorkerTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class GearmanTypedDict(TypedDict):
    status: NotRequired[Nullable[List[StatusTypedDict]]]
    version: NotRequired[str]
    workers: NotRequired[Nullable[List[WorkerTypedDict]]]


class Gearman(BaseModel):
    status: OptionalNullable[List[Status]] = UNSET

    version: Optional[str] = None

    workers: OptionalNullable[List[Worker]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["status", "version", "workers"]
        nullable_fields = ["status", "workers"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
