"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .chromedevtools import ChromeDevtools, ChromeDevtoolsTypedDict
from .cobaltstrike import CobaltStrike, CobaltStrikeTypedDict
from .elasticsearch import ElasticSearch, ElasticSearchTypedDict
from .fortigate import Fortigate, FortigateTypedDict
from .graphql import Graphql, GraphqlTypedDict
from .http import HTTP, HTTPTypedDict
from .ivantiavalanche import IvantiAvalanche, IvantiAvalancheTypedDict
from .kubernetes import Kubernetes, KubernetesTypedDict
from .ollama import Ollama, OllamaTypedDict
from .opendirectory import OpenDirectory, OpenDirectoryTypedDict
from .plexmediaserver import PlexMediaServer, PlexMediaServerTypedDict
from .pprof import Pprof, PprofTypedDict
from .prometheus import Prometheus, PrometheusTypedDict
from .prometheustarget import PrometheusTarget, PrometheusTargetTypedDict
from .redlionweb import RedlionWeb, RedlionWebTypedDict
from .scadaview import ScadaView, ScadaViewTypedDict
from .screenshot import Screenshot, ScreenshotTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class TransportProtocol(str, Enum):
    UNKNOWN = ""
    TCP = "tcp"
    UDP = "udp"
    ICMP = "icmp"
    QUIC = "quic"


class EndpointScanStateTypedDict(TypedDict):
    banner: NotRequired[str]
    banner_hash_sha256: NotRequired[str]
    chrome_devtools: NotRequired[ChromeDevtoolsTypedDict]
    cobalt_strike: NotRequired[CobaltStrikeTypedDict]
    elasticsearch: NotRequired[ElasticSearchTypedDict]
    endpoint_type: NotRequired[str]
    fortigate: NotRequired[FortigateTypedDict]
    graphql: NotRequired[GraphqlTypedDict]
    hostname: NotRequired[str]
    http: NotRequired[HTTPTypedDict]
    ip: NotRequired[str]
    ivanti_avalanche: NotRequired[IvantiAvalancheTypedDict]
    kubernetes: NotRequired[KubernetesTypedDict]
    ollama: NotRequired[OllamaTypedDict]
    open_directory: NotRequired[OpenDirectoryTypedDict]
    path: NotRequired[str]
    plex_media_server: NotRequired[PlexMediaServerTypedDict]
    port: NotRequired[int]
    pprof: NotRequired[PprofTypedDict]
    prometheus: NotRequired[PrometheusTypedDict]
    prometheus_target: NotRequired[PrometheusTargetTypedDict]
    redlion_web: NotRequired[RedlionWebTypedDict]
    scada_view: NotRequired[ScadaViewTypedDict]
    scan_time: NotRequired[str]
    screenshots: NotRequired[Nullable[List[ScreenshotTypedDict]]]
    transport_protocol: NotRequired[TransportProtocol]


class EndpointScanState(BaseModel):
    banner: Optional[str] = None

    banner_hash_sha256: Optional[str] = None

    chrome_devtools: Optional[ChromeDevtools] = None

    cobalt_strike: Optional[CobaltStrike] = None

    elasticsearch: Optional[ElasticSearch] = None

    endpoint_type: Optional[str] = None

    fortigate: Optional[Fortigate] = None

    graphql: Optional[Graphql] = None

    hostname: Optional[str] = None

    http: Optional[HTTP] = None

    ip: Optional[str] = None

    ivanti_avalanche: Optional[IvantiAvalanche] = None

    kubernetes: Optional[Kubernetes] = None

    ollama: Optional[Ollama] = None

    open_directory: Optional[OpenDirectory] = None

    path: Optional[str] = None

    plex_media_server: Optional[PlexMediaServer] = None

    port: Optional[int] = None

    pprof: Optional[Pprof] = None

    prometheus: Optional[Prometheus] = None

    prometheus_target: Optional[PrometheusTarget] = None

    redlion_web: Optional[RedlionWeb] = None

    scada_view: Optional[ScadaView] = None

    scan_time: Optional[str] = None

    screenshots: OptionalNullable[List[Screenshot]] = UNSET

    transport_protocol: Optional[TransportProtocol] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "banner",
            "banner_hash_sha256",
            "chrome_devtools",
            "cobalt_strike",
            "elasticsearch",
            "endpoint_type",
            "fortigate",
            "graphql",
            "hostname",
            "http",
            "ip",
            "ivanti_avalanche",
            "kubernetes",
            "ollama",
            "open_directory",
            "path",
            "plex_media_server",
            "port",
            "pprof",
            "prometheus",
            "prometheus_target",
            "redlion_web",
            "scada_view",
            "scan_time",
            "screenshots",
            "transport_protocol",
        ]
        nullable_fields = ["screenshots"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
