"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .dns_edns import DNSEDNS, DNSEDNSTypedDict
from .dns_resourcerecord import DNSResourceRecord, DNSResourceRecordTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class RCode(str, Enum):
    r"""A enumerated field indicating the result of the request. The most common values are defined in RFC 1035."""

    UNKNOWN = ""
    SUCCESS = "success"
    FORMAT_ERROR = "format_error"
    SERVER_FAILURE = "server_failure"
    NAME_ERROR = "name_error"
    NOT_IMPLEMENTED = "not_implemented"
    REFUSED = "refused"
    YX_DOMAIN = "yx_domain"
    YX_RRSET = "yx_rrset"
    NX_RRSET = "nx_rrset"
    NOT_AUTH = "not_auth"
    NOT_ZONE = "not_zone"
    BAD_SIG = "bad_sig"
    BAD_KEY = "bad_key"
    BAD_TIME = "bad_time"
    BAD_MODE = "bad_mode"
    BAD_NAME = "bad_name"
    BAD_ALG = "bad_alg"
    BAD_TRUNC = "bad_trunc"
    BAD_COOKIE = "bad_cookie"


class ServerType(str, Enum):
    r"""An enumerated value indicating the behavior of the server. An AUTHORITATIVE server fulfills requests for domain names it controls, which are not listed by the server. FORWARDING and RECURSIVE_RESOLVER servers fulfill requests indirectly for domain names they do not control. A RECURSIVE_RESOLVER will query ip.parrotdns.com itself, resulting in its own IP address being present in the dns.answers.response field."""

    UNKNOWN = ""
    RECURSIVE_RESOLVER = "recursive_resolver"
    AUTHORITATIVE = "authoritative"
    FORWARDING = "forwarding"
    REDIRECTING = "redirecting"


class DNSTypedDict(TypedDict):
    additionals: NotRequired[Nullable[List[DNSResourceRecordTypedDict]]]
    r"""A list of resource records (RRs) contained in the ADDITIONAL section of the response."""
    answers: NotRequired[Nullable[List[DNSResourceRecordTypedDict]]]
    r"""A list of resource records (RRs) contained in the ANSWER section of the response."""
    authorities: NotRequired[Nullable[List[DNSResourceRecordTypedDict]]]
    r"""A list of resource records (RRs) contained in the AUTHORITIES section of the response."""
    edns: NotRequired[DNSEDNSTypedDict]
    questions: NotRequired[Nullable[List[DNSResourceRecordTypedDict]]]
    r"""A list of resource records (RRs) contained in the QUESTION section of the response, which may echo the request that the server is responding to."""
    r_code: NotRequired[RCode]
    r"""A enumerated field indicating the result of the request. The most common values are defined in RFC 1035."""
    resolves_correctly: NotRequired[bool]
    r"""Whether the server returns an IP address for ip.parrotdns.com that matches the authoritative server, which is controlled by Censys."""
    server_type: NotRequired[ServerType]
    r"""An enumerated value indicating the behavior of the server. An AUTHORITATIVE server fulfills requests for domain names it controls, which are not listed by the server. FORWARDING and RECURSIVE_RESOLVER servers fulfill requests indirectly for domain names they do not control. A RECURSIVE_RESOLVER will query ip.parrotdns.com itself, resulting in its own IP address being present in the dns.answers.response field."""
    version: NotRequired[str]


class DNS(BaseModel):
    additionals: OptionalNullable[List[DNSResourceRecord]] = UNSET
    r"""A list of resource records (RRs) contained in the ADDITIONAL section of the response."""

    answers: OptionalNullable[List[DNSResourceRecord]] = UNSET
    r"""A list of resource records (RRs) contained in the ANSWER section of the response."""

    authorities: OptionalNullable[List[DNSResourceRecord]] = UNSET
    r"""A list of resource records (RRs) contained in the AUTHORITIES section of the response."""

    edns: Optional[DNSEDNS] = None

    questions: OptionalNullable[List[DNSResourceRecord]] = UNSET
    r"""A list of resource records (RRs) contained in the QUESTION section of the response, which may echo the request that the server is responding to."""

    r_code: Optional[RCode] = None
    r"""A enumerated field indicating the result of the request. The most common values are defined in RFC 1035."""

    resolves_correctly: Optional[bool] = None
    r"""Whether the server returns an IP address for ip.parrotdns.com that matches the authoritative server, which is controlled by Censys."""

    server_type: Optional[ServerType] = None
    r"""An enumerated value indicating the behavior of the server. An AUTHORITATIVE server fulfills requests for domain names it controls, which are not listed by the server. FORWARDING and RECURSIVE_RESOLVER servers fulfill requests indirectly for domain names they do not control. A RECURSIVE_RESOLVER will query ip.parrotdns.com itself, resulting in its own IP address being present in the dns.answers.response field."""

    version: Optional[str] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "additionals",
            "answers",
            "authorities",
            "edns",
            "questions",
            "r_code",
            "resolves_correctly",
            "server_type",
            "version",
        ]
        nullable_fields = ["additionals", "answers", "authorities", "questions"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
