"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List
from typing_extensions import NotRequired, TypedDict


class DistinguishedNameTypedDict(TypedDict):
    common_name: NotRequired[Nullable[List[str]]]
    r"""The commonName (CN) elements of the Distinguished Name (OID: 2.5.4.3)."""
    country: NotRequired[Nullable[List[str]]]
    r"""The countryName (C) elements of the Distinguished Name (OID: 2.5.4.6)."""
    domain_component: NotRequired[Nullable[List[str]]]
    r"""The domainComponent (DC) elements of the Distinguished Name (OID: 0.9.2342.19200300.100.1.25)."""
    email_address: NotRequired[Nullable[List[str]]]
    r"""The emailAddress (E) elements of the Distinguished Name (OID: 1.2.840.113549.1.9.1)."""
    given_name: NotRequired[Nullable[List[str]]]
    r"""The givenName (G) elements of the Distinguished Name (OID: 2.5.4.42)."""
    jurisdiction_country: NotRequired[Nullable[List[str]]]
    r"""The jurisdictionCountry elements of the Distinguished Name (OID: 1.3.6.1.4.1.311.60.2.1.3)."""
    jurisdiction_locality: NotRequired[Nullable[List[str]]]
    r"""The jurisdictionLocality elements of the Distinguished Name (OID: 1.3.6.1.4.1.311.60.2.1.1)."""
    jurisdiction_province: NotRequired[Nullable[List[str]]]
    r"""The jurisdictionStateOrProvince elements of the Distinguished Name (OID: 1.3.6.1.4.1.311.60.2.1.2)."""
    locality: NotRequired[Nullable[List[str]]]
    r"""The localityName (L) elements of the Distinguished Name (OID: 2.5.4.7)."""
    organization: NotRequired[Nullable[List[str]]]
    r"""The organizationName (O) elements of the Distinguished Name (OID: 2.5.4.10)."""
    organization_id: NotRequired[Nullable[List[str]]]
    organizational_unit: NotRequired[Nullable[List[str]]]
    r"""The organizationalUnit (OU) elements of the Distinguished Name (OID: 2.5.4.11)."""
    postal_code: NotRequired[Nullable[List[str]]]
    r"""The postalCode elements of the Distinguished Name (OID: 2.5.4.17)."""
    province: NotRequired[Nullable[List[str]]]
    r"""The stateOrProvinceName (ST) elements of the Distinguished Name (OID: 2.5.4.8)."""
    serial_number: NotRequired[Nullable[List[str]]]
    r"""The serialNumber elements of the Distinguished Name (OID: 2.5.4.5)."""
    street_address: NotRequired[Nullable[List[str]]]
    r"""The streetAddress (STREET) elements of the Distinguished Name (OID: 2.5.4.9)."""
    surname: NotRequired[Nullable[List[str]]]
    r"""The surname (SN) elements of the Distinguished Name (OID: 2.5.4.4)."""


class DistinguishedName(BaseModel):
    common_name: OptionalNullable[List[str]] = UNSET
    r"""The commonName (CN) elements of the Distinguished Name (OID: 2.5.4.3)."""

    country: OptionalNullable[List[str]] = UNSET
    r"""The countryName (C) elements of the Distinguished Name (OID: 2.5.4.6)."""

    domain_component: OptionalNullable[List[str]] = UNSET
    r"""The domainComponent (DC) elements of the Distinguished Name (OID: 0.9.2342.19200300.100.1.25)."""

    email_address: OptionalNullable[List[str]] = UNSET
    r"""The emailAddress (E) elements of the Distinguished Name (OID: 1.2.840.113549.1.9.1)."""

    given_name: OptionalNullable[List[str]] = UNSET
    r"""The givenName (G) elements of the Distinguished Name (OID: 2.5.4.42)."""

    jurisdiction_country: OptionalNullable[List[str]] = UNSET
    r"""The jurisdictionCountry elements of the Distinguished Name (OID: 1.3.6.1.4.1.311.60.2.1.3)."""

    jurisdiction_locality: OptionalNullable[List[str]] = UNSET
    r"""The jurisdictionLocality elements of the Distinguished Name (OID: 1.3.6.1.4.1.311.60.2.1.1)."""

    jurisdiction_province: OptionalNullable[List[str]] = UNSET
    r"""The jurisdictionStateOrProvince elements of the Distinguished Name (OID: 1.3.6.1.4.1.311.60.2.1.2)."""

    locality: OptionalNullable[List[str]] = UNSET
    r"""The localityName (L) elements of the Distinguished Name (OID: 2.5.4.7)."""

    organization: OptionalNullable[List[str]] = UNSET
    r"""The organizationName (O) elements of the Distinguished Name (OID: 2.5.4.10)."""

    organization_id: OptionalNullable[List[str]] = UNSET

    organizational_unit: OptionalNullable[List[str]] = UNSET
    r"""The organizationalUnit (OU) elements of the Distinguished Name (OID: 2.5.4.11)."""

    postal_code: OptionalNullable[List[str]] = UNSET
    r"""The postalCode elements of the Distinguished Name (OID: 2.5.4.17)."""

    province: OptionalNullable[List[str]] = UNSET
    r"""The stateOrProvinceName (ST) elements of the Distinguished Name (OID: 2.5.4.8)."""

    serial_number: OptionalNullable[List[str]] = UNSET
    r"""The serialNumber elements of the Distinguished Name (OID: 2.5.4.5)."""

    street_address: OptionalNullable[List[str]] = UNSET
    r"""The streetAddress (STREET) elements of the Distinguished Name (OID: 2.5.4.9)."""

    surname: OptionalNullable[List[str]] = UNSET
    r"""The surname (SN) elements of the Distinguished Name (OID: 2.5.4.4)."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "common_name",
            "country",
            "domain_component",
            "email_address",
            "given_name",
            "jurisdiction_country",
            "jurisdiction_locality",
            "jurisdiction_province",
            "locality",
            "organization",
            "organization_id",
            "organizational_unit",
            "postal_code",
            "province",
            "serial_number",
            "street_address",
            "surname",
        ]
        nullable_fields = [
            "common_name",
            "country",
            "domain_component",
            "email_address",
            "given_name",
            "jurisdiction_country",
            "jurisdiction_locality",
            "jurisdiction_province",
            "locality",
            "organization",
            "organization_id",
            "organizational_unit",
            "postal_code",
            "province",
            "serial_number",
            "street_address",
            "surname",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
