"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from censys_platform.types import BaseModel
from enum import Enum
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class CVSSv4ComponentsAttackComplexity(str, Enum):
    r"""Indicates conditions beyond the attacker’s control that must exist in order to exploit the vulnerability. The Attack Complexity metric is scored as either Low or High. There are two possible values: Low (L) – There are no specific pre-conditions required for exploitation, High (H) – The attacker must complete some number of preparatory steps in order to get access."""

    UNKNOWN = ""
    LOW = "low"
    HIGH = "high"


class AttackRequirements(str, Enum):
    UNKNOWN = ""
    NONE = "none"
    PRESENT = "present"


class CVSSv4ComponentsAttackVector(str, Enum):
    r"""Indicates the level of access required for an attacker to exploit the vulnerability. The Attack Vector metric is scored in one of four levels: Network (N) – Vulnerabilities with this rating are remotely exploitable, from one or more hops away, up to, and including, remote exploitation over the Internet, Adjacent (A) – A vulnerability with this rating requires network adjacency for exploitation. The attack must be launched from the same physical or logical network, Local (L) – Vulnerabilities with this rating are not exploitable over a network, Physical (P) – An attacker must physically interact with the target system."""

    UNKNOWN = ""
    NETWORK = "network"
    ADJACENT = "adjacent"
    LOCAL = "local"
    PHYSICAL = "physical"


class Automatable(str, Enum):
    UNKNOWN = ""
    NO = "no"
    YES = "yes"


class CVSSv4ComponentsAvailability(str, Enum):
    r"""If an attack renders information unavailable, such as when a system crashes or through a DDoS attack, availability is negatively impacted. Availability has three possible values: None (N) – There is no loss of availability, Low (L) – Availability might be intermittently limited, or performance might be negatively impacted, as a result of a successful attack, High (H) – There is a complete loss of availability of the impacted system or information."""

    UNKNOWN = ""
    NONE = "none"
    LOW = "low"
    HIGH = "high"


class CVSSv4ComponentsConfidentiality(str, Enum):
    r"""Refers to the disclosure of sensitive information to authorized and unauthorized users, with the goal being that only authorized users are able to access the target data. Confidentiality has three potential values: High (H) – The attacker has full access to all resources in the impacted system, including highly sensitive information such as encryption keys, Low (L) – The attacker has partial access to information, with no control over what, specifically, they are able to access, None (N) – No data is accessible to unauthorized users as a result of the exploit."""

    UNKNOWN = ""
    NONE = "none"
    LOW = "low"
    HIGH = "high"


class CVSSv4ComponentsIntegrity(str, Enum):
    r"""Refers to whether the protected information has been tampered with or changed in any way. If there is no way for an attacker to alter the accuracy or completeness of the information, integrity has been maintained. Integrity has three values: None (N) – There is no loss of the integrity of any information, Low (L) – A limited amount of information might be tampered with or modified, but there is no serious impact on the protected system, High (H) – The attacker can modify any/all information on the target system, resulting in a complete loss of integrity."""

    UNKNOWN = ""
    NONE = "none"
    LOW = "low"
    HIGH = "high"


class CVSSv4ComponentsPrivilegesRequired(str, Enum):
    r"""Describes the level of privileges or access an attacker must have before successful exploitation. There are three possible values: None (N) – There is no privilege or special access required to conduct the attack, Low (L) – The attacker requires basic, “user” level privileges to leverage the exploit, High (H) – Administrative or similar access privileges are required for successful attack."""

    UNKNOWN = ""
    NONE = "none"
    LOW = "low"
    HIGH = "high"


class ProviderUrgency(str, Enum):
    UNKNOWN = ""
    CLEAR = "clear"
    GREEN = "green"
    AMBER = "amber"
    RED = "red"


class Recovery(str, Enum):
    UNKNOWN = ""
    AUTOMATIC = "automatic"
    USER = "user"
    IRRECOVERABLE = "irrecoverable"


class Safety(str, Enum):
    UNKNOWN = ""
    NEGLIGIBLE = "negligible"
    PRESENT = "present"


class CVSSv4ComponentsUserInteraction(str, Enum):
    r"""Describes whether a user, other than the attacker, is required to do anything or participate in exploitation of the vulnerability. User interaction has two possible values: None (N) – No user interaction is required, Required (R) – A user must complete some steps for the exploit to succeed. For example, a user might be required to install some software."""

    UNKNOWN = ""
    NONE = "none"
    REQUIRED = "required"


class ValueDensity(str, Enum):
    UNKNOWN = ""
    DIFFUSE = "diffuse"
    CONCENTRATED = "concentrated"


class VulnerabilityResponseEffort(str, Enum):
    UNKNOWN = ""
    LOW = "low"
    MODERATE = "moderate"
    HIGH = "high"


class CVSSv4ComponentsTypedDict(TypedDict):
    attack_complexity: NotRequired[CVSSv4ComponentsAttackComplexity]
    r"""Indicates conditions beyond the attacker’s control that must exist in order to exploit the vulnerability. The Attack Complexity metric is scored as either Low or High. There are two possible values: Low (L) – There are no specific pre-conditions required for exploitation, High (H) – The attacker must complete some number of preparatory steps in order to get access."""
    attack_requirements: NotRequired[AttackRequirements]
    attack_vector: NotRequired[CVSSv4ComponentsAttackVector]
    r"""Indicates the level of access required for an attacker to exploit the vulnerability. The Attack Vector metric is scored in one of four levels: Network (N) – Vulnerabilities with this rating are remotely exploitable, from one or more hops away, up to, and including, remote exploitation over the Internet, Adjacent (A) – A vulnerability with this rating requires network adjacency for exploitation. The attack must be launched from the same physical or logical network, Local (L) – Vulnerabilities with this rating are not exploitable over a network, Physical (P) – An attacker must physically interact with the target system."""
    automatable: NotRequired[Automatable]
    availability: NotRequired[CVSSv4ComponentsAvailability]
    r"""If an attack renders information unavailable, such as when a system crashes or through a DDoS attack, availability is negatively impacted. Availability has three possible values: None (N) – There is no loss of availability, Low (L) – Availability might be intermittently limited, or performance might be negatively impacted, as a result of a successful attack, High (H) – There is a complete loss of availability of the impacted system or information."""
    confidentiality: NotRequired[CVSSv4ComponentsConfidentiality]
    r"""Refers to the disclosure of sensitive information to authorized and unauthorized users, with the goal being that only authorized users are able to access the target data. Confidentiality has three potential values: High (H) – The attacker has full access to all resources in the impacted system, including highly sensitive information such as encryption keys, Low (L) – The attacker has partial access to information, with no control over what, specifically, they are able to access, None (N) – No data is accessible to unauthorized users as a result of the exploit."""
    integrity: NotRequired[CVSSv4ComponentsIntegrity]
    r"""Refers to whether the protected information has been tampered with or changed in any way. If there is no way for an attacker to alter the accuracy or completeness of the information, integrity has been maintained. Integrity has three values: None (N) – There is no loss of the integrity of any information, Low (L) – A limited amount of information might be tampered with or modified, but there is no serious impact on the protected system, High (H) – The attacker can modify any/all information on the target system, resulting in a complete loss of integrity."""
    privileges_required: NotRequired[CVSSv4ComponentsPrivilegesRequired]
    r"""Describes the level of privileges or access an attacker must have before successful exploitation. There are three possible values: None (N) – There is no privilege or special access required to conduct the attack, Low (L) – The attacker requires basic, “user” level privileges to leverage the exploit, High (H) – Administrative or similar access privileges are required for successful attack."""
    provider_urgency: NotRequired[ProviderUrgency]
    recovery: NotRequired[Recovery]
    safety: NotRequired[Safety]
    user_interaction: NotRequired[CVSSv4ComponentsUserInteraction]
    r"""Describes whether a user, other than the attacker, is required to do anything or participate in exploitation of the vulnerability. User interaction has two possible values: None (N) – No user interaction is required, Required (R) – A user must complete some steps for the exploit to succeed. For example, a user might be required to install some software."""
    value_density: NotRequired[ValueDensity]
    vulnerability_response_effort: NotRequired[VulnerabilityResponseEffort]


class CVSSv4Components(BaseModel):
    attack_complexity: Optional[CVSSv4ComponentsAttackComplexity] = None
    r"""Indicates conditions beyond the attacker’s control that must exist in order to exploit the vulnerability. The Attack Complexity metric is scored as either Low or High. There are two possible values: Low (L) – There are no specific pre-conditions required for exploitation, High (H) – The attacker must complete some number of preparatory steps in order to get access."""

    attack_requirements: Optional[AttackRequirements] = None

    attack_vector: Optional[CVSSv4ComponentsAttackVector] = None
    r"""Indicates the level of access required for an attacker to exploit the vulnerability. The Attack Vector metric is scored in one of four levels: Network (N) – Vulnerabilities with this rating are remotely exploitable, from one or more hops away, up to, and including, remote exploitation over the Internet, Adjacent (A) – A vulnerability with this rating requires network adjacency for exploitation. The attack must be launched from the same physical or logical network, Local (L) – Vulnerabilities with this rating are not exploitable over a network, Physical (P) – An attacker must physically interact with the target system."""

    automatable: Optional[Automatable] = None

    availability: Optional[CVSSv4ComponentsAvailability] = None
    r"""If an attack renders information unavailable, such as when a system crashes or through a DDoS attack, availability is negatively impacted. Availability has three possible values: None (N) – There is no loss of availability, Low (L) – Availability might be intermittently limited, or performance might be negatively impacted, as a result of a successful attack, High (H) – There is a complete loss of availability of the impacted system or information."""

    confidentiality: Optional[CVSSv4ComponentsConfidentiality] = None
    r"""Refers to the disclosure of sensitive information to authorized and unauthorized users, with the goal being that only authorized users are able to access the target data. Confidentiality has three potential values: High (H) – The attacker has full access to all resources in the impacted system, including highly sensitive information such as encryption keys, Low (L) – The attacker has partial access to information, with no control over what, specifically, they are able to access, None (N) – No data is accessible to unauthorized users as a result of the exploit."""

    integrity: Optional[CVSSv4ComponentsIntegrity] = None
    r"""Refers to whether the protected information has been tampered with or changed in any way. If there is no way for an attacker to alter the accuracy or completeness of the information, integrity has been maintained. Integrity has three values: None (N) – There is no loss of the integrity of any information, Low (L) – A limited amount of information might be tampered with or modified, but there is no serious impact on the protected system, High (H) – The attacker can modify any/all information on the target system, resulting in a complete loss of integrity."""

    privileges_required: Optional[CVSSv4ComponentsPrivilegesRequired] = None
    r"""Describes the level of privileges or access an attacker must have before successful exploitation. There are three possible values: None (N) – There is no privilege or special access required to conduct the attack, Low (L) – The attacker requires basic, “user” level privileges to leverage the exploit, High (H) – Administrative or similar access privileges are required for successful attack."""

    provider_urgency: Optional[ProviderUrgency] = None

    recovery: Optional[Recovery] = None

    safety: Optional[Safety] = None

    user_interaction: Optional[CVSSv4ComponentsUserInteraction] = None
    r"""Describes whether a user, other than the attacker, is required to do anything or participate in exploitation of the vulnerability. User interaction has two possible values: None (N) – No user interaction is required, Required (R) – A user must complete some steps for the exploit to succeed. For example, a user might be required to install some software."""

    value_density: Optional[ValueDensity] = None

    vulnerability_response_effort: Optional[VulnerabilityResponseEffort] = None
