"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class ConnectionTypedDict(TypedDict):
    ahs_length: NotRequired[int]
    cmd_seq: NotRequired[int]
    isid: NotRequired[int]
    keyval_pairs: NotRequired[Nullable[List[str]]]
    max_new_cmds: NotRequired[int]
    status_seq: NotRequired[int]
    tsih: NotRequired[int]
    version_active: NotRequired[int]
    version_max: NotRequired[int]


class Connection(BaseModel):
    ahs_length: Optional[int] = None

    cmd_seq: Optional[int] = None

    isid: Optional[int] = None

    keyval_pairs: OptionalNullable[List[str]] = UNSET

    max_new_cmds: Optional[int] = None

    status_seq: Optional[int] = None

    tsih: Optional[int] = None

    version_active: Optional[int] = None

    version_max: Optional[int] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "ahs_length",
            "cmd_seq",
            "isid",
            "keyval_pairs",
            "max_new_cmds",
            "status_seq",
            "tsih",
            "version_active",
            "version_max",
        ]
        nullable_fields = ["keyval_pairs"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
