"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from censys_platform.types import BaseModel, Nullable, UNSET_SENTINEL
from datetime import datetime
from enum import Enum
from pydantic import model_serializer
from typing_extensions import TypedDict


class CollectionStatus(str, Enum):
    UNSPECIFIED = "unspecified"
    POPULATING = "populating"
    ACTIVE = "active"
    PAUSED = "paused"
    ARCHIVED = "archived"


class StatusReason(str, Enum):
    UNSPECIFIED = "unspecified"
    NOT_ENOUGH_CREDITS = "not_enough_credits"
    NOT_ENTITLED = "not_entitled"
    TOO_MANY_ASSETS = "too_many_assets"
    MANUAL = "manual"
    QUERY_CHANGED = "query_changed"
    INITIAL = "initial"


class CollectionTypedDict(TypedDict):
    added_assets_24_hours: int
    create_time: datetime
    description: str
    id: str
    name: str
    query: str
    removed_assets_24_hours: int
    status: CollectionStatus
    status_reason: Nullable[StatusReason]
    total_assets: int


class Collection(BaseModel):
    added_assets_24_hours: int

    create_time: datetime

    description: str

    id: str

    name: str

    query: str

    removed_assets_24_hours: int

    status: CollectionStatus

    status_reason: Nullable[StatusReason]

    total_assets: int

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["status_reason"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
