"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .chromedevtools_target import ChromeDevtoolsTarget, ChromeDevtoolsTargetTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class ChromeDevtoolsTypedDict(TypedDict):
    browser: NotRequired[str]
    protocol_version: NotRequired[str]
    targets: NotRequired[Nullable[List[ChromeDevtoolsTargetTypedDict]]]
    user_agent: NotRequired[str]
    v8_version: NotRequired[str]
    webkit_version: NotRequired[str]


class ChromeDevtools(BaseModel):
    browser: Optional[str] = None

    protocol_version: Optional[str] = None

    targets: OptionalNullable[List[ChromeDevtoolsTarget]] = UNSET

    user_agent: Optional[str] = None

    v8_version: Optional[str] = None

    webkit_version: Optional[str] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "browser",
            "protocol_version",
            "targets",
            "user_agent",
            "v8_version",
            "webkit_version",
        ]
        nullable_fields = ["targets"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
