"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .chromecast_namespace import ChromecastNamespace, ChromecastNamespaceTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class ChromecastApplicationTypedDict(TypedDict):
    app_id: NotRequired[str]
    app_type: NotRequired[str]
    display_name: NotRequired[str]
    namespaces: NotRequired[Nullable[List[ChromecastNamespaceTypedDict]]]
    session_id: NotRequired[str]
    transport_id: NotRequired[str]


class ChromecastApplication(BaseModel):
    app_id: Optional[str] = None

    app_type: Optional[str] = None

    display_name: Optional[str] = None

    namespaces: OptionalNullable[List[ChromecastNamespace]] = UNSET

    session_id: Optional[str] = None

    transport_id: Optional[str] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "app_id",
            "app_type",
            "display_name",
            "namespaces",
            "session_id",
            "transport_id",
        ]
        nullable_fields = ["namespaces"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
