"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .authorityinfoaccess import AuthorityInfoAccess, AuthorityInfoAccessTypedDict
from .basicconstraints import BasicConstraints, BasicConstraintsTypedDict
from .cabforganizationid import CabfOrganizationID, CabfOrganizationIDTypedDict
from .certificatepolicy import CertificatePolicy, CertificatePolicyTypedDict
from .extendedkeyusage import ExtendedKeyUsage, ExtendedKeyUsageTypedDict
from .generalnames import GeneralNames, GeneralNamesTypedDict
from .keyusage import KeyUsage, KeyUsageTypedDict
from .nameconstraints import NameConstraints, NameConstraintsTypedDict
from .qcstatements import QcStatements, QcStatementsTypedDict
from .signedcertificatetimestamp import (
    SignedCertificateTimestamp,
    SignedCertificateTimestampTypedDict,
)
from .torservicedescriptor import TorServiceDescriptor, TorServiceDescriptorTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class CertificateExtensionsTypedDict(TypedDict):
    authority_info_access: NotRequired[AuthorityInfoAccessTypedDict]
    authority_key_id: NotRequired[str]
    r"""A key identifier, usually a digest of the DER-encoded SubjectPublicKeyInfo."""
    basic_constraints: NotRequired[BasicConstraintsTypedDict]
    cabf_organization_id: NotRequired[CabfOrganizationIDTypedDict]
    certificate_policies: NotRequired[Nullable[List[CertificatePolicyTypedDict]]]
    r"""The parsed id-ce-certificatePolicies extension (OID: 2.5.29.32)."""
    crl_distribution_points: NotRequired[Nullable[List[str]]]
    r"""The parsed id-ce-cRLDistributionPoints extension (OID: 2.5.29.31). Contents are a list of distributionPoint URLs; other distributionPoint types are omitted)."""
    ct_poison: NotRequired[bool]
    r"""Whether the certificate possesses the pre-certificate \"poison\" extension (OID: 1.3.6.1.4.1.11129.2.4.3)."""
    extended_key_usage: NotRequired[ExtendedKeyUsageTypedDict]
    issuer_alt_name: NotRequired[GeneralNamesTypedDict]
    key_usage: NotRequired[KeyUsageTypedDict]
    name_constraints: NotRequired[NameConstraintsTypedDict]
    qc_statements: NotRequired[QcStatementsTypedDict]
    signed_certificate_timestamps: NotRequired[
        Nullable[List[SignedCertificateTimestampTypedDict]]
    ]
    subject_alt_name: NotRequired[GeneralNamesTypedDict]
    subject_key_id: NotRequired[str]
    r"""A key identifier, usually a digest of the DER-encoded SubjectPublicKeyInfo.."""
    tor_service_descriptors: NotRequired[Nullable[List[TorServiceDescriptorTypedDict]]]


class CertificateExtensions(BaseModel):
    authority_info_access: Optional[AuthorityInfoAccess] = None

    authority_key_id: Optional[str] = None
    r"""A key identifier, usually a digest of the DER-encoded SubjectPublicKeyInfo."""

    basic_constraints: Optional[BasicConstraints] = None

    cabf_organization_id: Optional[CabfOrganizationID] = None

    certificate_policies: OptionalNullable[List[CertificatePolicy]] = UNSET
    r"""The parsed id-ce-certificatePolicies extension (OID: 2.5.29.32)."""

    crl_distribution_points: OptionalNullable[List[str]] = UNSET
    r"""The parsed id-ce-cRLDistributionPoints extension (OID: 2.5.29.31). Contents are a list of distributionPoint URLs; other distributionPoint types are omitted)."""

    ct_poison: Optional[bool] = None
    r"""Whether the certificate possesses the pre-certificate \"poison\" extension (OID: 1.3.6.1.4.1.11129.2.4.3)."""

    extended_key_usage: Optional[ExtendedKeyUsage] = None

    issuer_alt_name: Optional[GeneralNames] = None

    key_usage: Optional[KeyUsage] = None

    name_constraints: Optional[NameConstraints] = None

    qc_statements: Optional[QcStatements] = None

    signed_certificate_timestamps: OptionalNullable[
        List[SignedCertificateTimestamp]
    ] = UNSET

    subject_alt_name: Optional[GeneralNames] = None

    subject_key_id: Optional[str] = None
    r"""A key identifier, usually a digest of the DER-encoded SubjectPublicKeyInfo.."""

    tor_service_descriptors: OptionalNullable[List[TorServiceDescriptor]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "authority_info_access",
            "authority_key_id",
            "basic_constraints",
            "cabf_organization_id",
            "certificate_policies",
            "crl_distribution_points",
            "ct_poison",
            "extended_key_usage",
            "issuer_alt_name",
            "key_usage",
            "name_constraints",
            "qc_statements",
            "signed_certificate_timestamps",
            "subject_alt_name",
            "subject_key_id",
            "tor_service_descriptors",
        ]
        nullable_fields = [
            "certificate_policies",
            "crl_distribution_points",
            "signed_certificate_timestamps",
            "tor_service_descriptors",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
