"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .certificateextensions import CertificateExtensions, CertificateExtensionsTypedDict
from .distinguishedname import DistinguishedName, DistinguishedNameTypedDict
from .extension import Extension, ExtensionTypedDict
from .signature import Signature, SignatureTypedDict
from .subjectkeyinfo import SubjectKeyInfo, SubjectKeyInfoTypedDict
from .validityperiod import ValidityPeriod, ValidityPeriodTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class CertificateParsedTypedDict(TypedDict):
    extensions: NotRequired[CertificateExtensionsTypedDict]
    issuer: NotRequired[DistinguishedNameTypedDict]
    issuer_dn: NotRequired[str]
    r"""Distinguished Name of the entity that has signed and issued the certificate."""
    ja4x: NotRequired[str]
    redacted: NotRequired[bool]
    serial_number: NotRequired[str]
    r"""Issuer-specific identifier of the certificate."""
    serial_number_hex: NotRequired[str]
    r"""Issuer-specific identifier of the certificate, represented as hexadecimal."""
    signature: NotRequired[SignatureTypedDict]
    subject: NotRequired[DistinguishedNameTypedDict]
    subject_dn: NotRequired[str]
    r"""Distinguished Name of the entity associated with the public key."""
    subject_key_info: NotRequired[SubjectKeyInfoTypedDict]
    unknown_extensions: NotRequired[Nullable[List[ExtensionTypedDict]]]
    validity_period: NotRequired[ValidityPeriodTypedDict]
    version: NotRequired[int]


class CertificateParsed(BaseModel):
    extensions: Optional[CertificateExtensions] = None

    issuer: Optional[DistinguishedName] = None

    issuer_dn: Optional[str] = None
    r"""Distinguished Name of the entity that has signed and issued the certificate."""

    ja4x: Optional[str] = None

    redacted: Optional[bool] = None

    serial_number: Optional[str] = None
    r"""Issuer-specific identifier of the certificate."""

    serial_number_hex: Optional[str] = None
    r"""Issuer-specific identifier of the certificate, represented as hexadecimal."""

    signature: Optional[Signature] = None

    subject: Optional[DistinguishedName] = None

    subject_dn: Optional[str] = None
    r"""Distinguished Name of the entity associated with the public key."""

    subject_key_info: Optional[SubjectKeyInfo] = None

    unknown_extensions: OptionalNullable[List[Extension]] = UNSET

    validity_period: Optional[ValidityPeriod] = None

    version: Optional[int] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "extensions",
            "issuer",
            "issuer_dn",
            "ja4x",
            "redacted",
            "serial_number",
            "serial_number_hex",
            "signature",
            "subject",
            "subject_dn",
            "subject_key_info",
            "unknown_extensions",
            "validity_period",
            "version",
        ]
        nullable_fields = ["unknown_extensions"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
