"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .certificate_parsed import CertificateParsed, CertificateParsedTypedDict
from .certificaterevocation import CertificateRevocation, CertificateRevocationTypedDict
from .ct import Ct, CtTypedDict
from .validation import Validation, ValidationTypedDict
from .zlint import ZLint, ZLintTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class ParseStatus(str, Enum):
    UNKNOWN = ""
    SUCCESS = "success"
    FAIL = "fail"
    CORRUPTED = "corrupted"


class ValidationLevel(str, Enum):
    r"""The extent to which the certificate's issuer validated the identity of the entity requesting the certificate. Options include Domain validated (DV), Organization Validated (OV), or Extended Validation (EV)."""

    UNKNOWN = ""
    DV = "dv"
    OV = "ov"
    EV = "ev"


class CertificateTypedDict(TypedDict):
    added_at: NotRequired[str]
    r"""When the certificate was added to the Censys dataset."""
    ct: NotRequired[CtTypedDict]
    ever_seen_in_scan: NotRequired[bool]
    r"""Whether the certificate has ever been presented by a service during a scan."""
    fingerprint_md5: NotRequired[str]
    r"""The MD-5 digest of the entire raw certificate. An identifier used by some systems."""
    fingerprint_sha1: NotRequired[str]
    r"""The SHA-1 digest of the entire raw certificate. An identifier used by some systems."""
    fingerprint_sha256: NotRequired[str]
    r"""The SHA-256 digest of the entire raw certificate. Its unique identifier, which Censys uses to index certificates records."""
    modified_at: NotRequired[str]
    r"""When the certificate record was last modified."""
    names: NotRequired[Nullable[List[str]]]
    r"""All the names contained in the certificate from various fields."""
    parent_spki_fingerprint_sha256: NotRequired[str]
    r"""DEPRECATED: Use parent_spki_subject_fingerprint_sha256"""
    parent_spki_subject_fingerprint_sha256: NotRequired[str]
    r"""The SHA-256 digest of the parent certificate's DER-encoded SubjectPublicKeyInfo concatenated with its Subject."""
    parse_status: NotRequired[ParseStatus]
    parsed: NotRequired[CertificateParsedTypedDict]
    precert: NotRequired[bool]
    r"""Whether the X.509 \"poison\" extension (OID: 1.3.6.1.4.1.11129.2.4.3) is marked critical, which prohibits the pre-certificate from being trusted."""
    revocation: NotRequired[CertificateRevocationTypedDict]
    revoked: NotRequired[bool]
    r"""Whether the certificate has been revoked before its expiry date by the issuer."""
    spki_fingerprint_sha256: NotRequired[str]
    r"""DEPRECATED: Use spki_subject_fingerprint_sha256"""
    spki_subject_fingerprint_sha256: NotRequired[str]
    r"""The SHA-256 digest of the certificate's DER-encoded SubjectPublicKeyInfo concatenated with its Subject."""
    tbs_fingerprint_sha256: NotRequired[str]
    r"""The SHA-256 digest of the unsigned certificate's contents."""
    tbs_no_ct_fingerprint_sha256: NotRequired[str]
    r"""The SHA-256 digest of the unsigned certificate with the CT Poison extension removed, if present. This represents the shared contents of a certificate and its corresponding pre-certificate."""
    validated_at: NotRequired[str]
    r"""When the certificate record's trust was last checked."""
    validation: NotRequired[ValidationTypedDict]
    validation_level: NotRequired[ValidationLevel]
    r"""The extent to which the certificate's issuer validated the identity of the entity requesting the certificate. Options include Domain validated (DV), Organization Validated (OV), or Extended Validation (EV)."""
    zlint: NotRequired[ZLintTypedDict]


class Certificate(BaseModel):
    added_at: Optional[str] = None
    r"""When the certificate was added to the Censys dataset."""

    ct: Optional[Ct] = None

    ever_seen_in_scan: Optional[bool] = None
    r"""Whether the certificate has ever been presented by a service during a scan."""

    fingerprint_md5: Optional[str] = None
    r"""The MD-5 digest of the entire raw certificate. An identifier used by some systems."""

    fingerprint_sha1: Optional[str] = None
    r"""The SHA-1 digest of the entire raw certificate. An identifier used by some systems."""

    fingerprint_sha256: Optional[str] = None
    r"""The SHA-256 digest of the entire raw certificate. Its unique identifier, which Censys uses to index certificates records."""

    modified_at: Optional[str] = None
    r"""When the certificate record was last modified."""

    names: OptionalNullable[List[str]] = UNSET
    r"""All the names contained in the certificate from various fields."""

    parent_spki_fingerprint_sha256: Optional[str] = None
    r"""DEPRECATED: Use parent_spki_subject_fingerprint_sha256"""

    parent_spki_subject_fingerprint_sha256: Optional[str] = None
    r"""The SHA-256 digest of the parent certificate's DER-encoded SubjectPublicKeyInfo concatenated with its Subject."""

    parse_status: Optional[ParseStatus] = None

    parsed: Optional[CertificateParsed] = None

    precert: Optional[bool] = None
    r"""Whether the X.509 \"poison\" extension (OID: 1.3.6.1.4.1.11129.2.4.3) is marked critical, which prohibits the pre-certificate from being trusted."""

    revocation: Optional[CertificateRevocation] = None

    revoked: Optional[bool] = None
    r"""Whether the certificate has been revoked before its expiry date by the issuer."""

    spki_fingerprint_sha256: Optional[str] = None
    r"""DEPRECATED: Use spki_subject_fingerprint_sha256"""

    spki_subject_fingerprint_sha256: Optional[str] = None
    r"""The SHA-256 digest of the certificate's DER-encoded SubjectPublicKeyInfo concatenated with its Subject."""

    tbs_fingerprint_sha256: Optional[str] = None
    r"""The SHA-256 digest of the unsigned certificate's contents."""

    tbs_no_ct_fingerprint_sha256: Optional[str] = None
    r"""The SHA-256 digest of the unsigned certificate with the CT Poison extension removed, if present. This represents the shared contents of a certificate and its corresponding pre-certificate."""

    validated_at: Optional[str] = None
    r"""When the certificate record's trust was last checked."""

    validation: Optional[Validation] = None

    validation_level: Optional[ValidationLevel] = None
    r"""The extent to which the certificate's issuer validated the identity of the entity requesting the certificate. Options include Domain validated (DV), Organization Validated (OV), or Extended Validation (EV)."""

    zlint: Optional[ZLint] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "added_at",
            "ct",
            "ever_seen_in_scan",
            "fingerprint_md5",
            "fingerprint_sha1",
            "fingerprint_sha256",
            "modified_at",
            "names",
            "parent_spki_fingerprint_sha256",
            "parent_spki_subject_fingerprint_sha256",
            "parse_status",
            "parsed",
            "precert",
            "revocation",
            "revoked",
            "spki_fingerprint_sha256",
            "spki_subject_fingerprint_sha256",
            "tbs_fingerprint_sha256",
            "tbs_no_ct_fingerprint_sha256",
            "validated_at",
            "validation",
            "validation_level",
            "zlint",
        ]
        nullable_fields = ["names"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
