"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .cpe import Cpe, CpeTypedDict
from .cpe_lifecycle import CPELifeCycle, CPELifeCycleTypedDict
from .evidence import Evidence, EvidenceTypedDict
from censys_platform.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class Source(str, Enum):
    UNKNOWN = ""
    CENSYS = "censys"
    RECOG = "recog"
    WAPPALYZER = "wappalyzer"
    THIRD_PARTY = "third_party"


class AttributeTypedDict(TypedDict):
    components: NotRequired[Nullable[List[CpeTypedDict]]]
    confidence: NotRequired[float]
    cpe: NotRequired[str]
    edition: NotRequired[str]
    evidence: NotRequired[Nullable[List[EvidenceTypedDict]]]
    life_cycle: NotRequired[CPELifeCycleTypedDict]
    part: NotRequired[str]
    product: NotRequired[str]
    source: NotRequired[Source]
    type: NotRequired[Nullable[List[str]]]
    update: NotRequired[str]
    vendor: NotRequired[str]
    version: NotRequired[str]


class Attribute(BaseModel):
    components: OptionalNullable[List[Cpe]] = UNSET

    confidence: Optional[float] = None

    cpe: Optional[str] = None

    edition: Optional[str] = None

    evidence: OptionalNullable[List[Evidence]] = UNSET

    life_cycle: Optional[CPELifeCycle] = None

    part: Optional[str] = None

    product: Optional[str] = None

    source: Optional[Source] = None

    type: OptionalNullable[List[str]] = UNSET

    update: Optional[str] = None

    vendor: Optional[str] = None

    version: Optional[str] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "components",
            "confidence",
            "cpe",
            "edition",
            "evidence",
            "life_cycle",
            "part",
            "product",
            "source",
            "type",
            "update",
            "vendor",
            "version",
        ]
        nullable_fields = ["components", "evidence", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
