# coding: utf-8

"""
    FINBOURNE Workflow API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List
from pydantic.v1 import StrictStr, Field, BaseModel, Field, conlist, constr 
from lusid_workflow.models.day_of_year import DayOfYear

class YearRegularity(BaseModel):
    """
    Year Regularity  # noqa: E501
    """
    dates: conlist(DayOfYear) = Field(..., description="The dates in the year")
    type:  StrictStr = Field(...,alias="type", description="The type of Date Regularity") 
    __properties = ["dates", "type"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> YearRegularity:
        """Create an instance of YearRegularity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in dates (list)
        _items = []
        if self.dates:
            for _item in self.dates:
                if _item:
                    _items.append(_item.to_dict())
            _dict['dates'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> YearRegularity:
        """Create an instance of YearRegularity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return YearRegularity.parse_obj(obj)

        _obj = YearRegularity.parse_obj({
            "dates": [DayOfYear.from_dict(_item) for _item in obj.get("dates")] if obj.get("dates") is not None else None,
            "type": obj.get("type")
        })
        return _obj
