# coding: utf-8

"""
    FINBOURNE Workflow API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, constr, validator 
from lusid_workflow.models.trigger_schema import TriggerSchema

class TransitionTriggerDefinition(BaseModel):
    """
    State changes happen in response to Triggers  # noqa: E501
    """
    name:  StrictStr = Field(...,alias="name", description="The key/Name of this Trigger") 
    trigger: TriggerSchema = Field(...)
    display_name:  Optional[StrictStr] = Field(None,alias="displayName", description="Display name for trigger") 
    description:  Optional[StrictStr] = Field(None,alias="description", description="Description of trigger") 
    __properties = ["name", "trigger", "displayName", "description"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransitionTriggerDefinition:
        """Create an instance of TransitionTriggerDefinition from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of trigger
        if self.trigger:
            _dict['trigger'] = self.trigger.to_dict()
        # set to None if display_name (nullable) is None
        # and __fields_set__ contains the field
        if self.display_name is None and "display_name" in self.__fields_set__:
            _dict['displayName'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransitionTriggerDefinition:
        """Create an instance of TransitionTriggerDefinition from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TransitionTriggerDefinition.parse_obj(obj)

        _obj = TransitionTriggerDefinition.parse_obj({
            "name": obj.get("name"),
            "trigger": TriggerSchema.from_dict(obj.get("trigger")) if obj.get("trigger") is not None else None,
            "display_name": obj.get("displayName"),
            "description": obj.get("description")
        })
        return _obj
