# coding: utf-8

"""
    FINBOURNE Workflow API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, constr, validator 

class TaskTransitionDefinition(BaseModel):
    """
    Defines a State change  # noqa: E501
    """
    from_state:  StrictStr = Field(...,alias="fromState", description="The State this Transition if coming From") 
    to_state:  StrictStr = Field(...,alias="toState", description="The State this Transition is going To") 
    trigger:  StrictStr = Field(...,alias="trigger", description="The Trigger for this Transition") 
    guard:  Optional[StrictStr] = Field(None,alias="guard", description="The Guard for this Transition, if any") 
    action:  Optional[StrictStr] = Field(None,alias="action", description="The Action to invoke on successful Transition") 
    display_name:  Optional[StrictStr] = Field(None,alias="displayName", description="Display name for transition") 
    description:  Optional[StrictStr] = Field(None,alias="description", description="Description for transition") 
    guard_description:  Optional[StrictStr] = Field(None,alias="guardDescription", description="Guard description for transition") 
    guard_condition_not_met_message:  Optional[StrictStr] = Field(None,alias="guardConditionNotMetMessage", description="Message when guard has not been met") 
    __properties = ["fromState", "toState", "trigger", "guard", "action", "displayName", "description", "guardDescription", "guardConditionNotMetMessage"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TaskTransitionDefinition:
        """Create an instance of TaskTransitionDefinition from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if guard (nullable) is None
        # and __fields_set__ contains the field
        if self.guard is None and "guard" in self.__fields_set__:
            _dict['guard'] = None

        # set to None if action (nullable) is None
        # and __fields_set__ contains the field
        if self.action is None and "action" in self.__fields_set__:
            _dict['action'] = None

        # set to None if display_name (nullable) is None
        # and __fields_set__ contains the field
        if self.display_name is None and "display_name" in self.__fields_set__:
            _dict['displayName'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if guard_description (nullable) is None
        # and __fields_set__ contains the field
        if self.guard_description is None and "guard_description" in self.__fields_set__:
            _dict['guardDescription'] = None

        # set to None if guard_condition_not_met_message (nullable) is None
        # and __fields_set__ contains the field
        if self.guard_condition_not_met_message is None and "guard_condition_not_met_message" in self.__fields_set__:
            _dict['guardConditionNotMetMessage'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TaskTransitionDefinition:
        """Create an instance of TaskTransitionDefinition from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TaskTransitionDefinition.parse_obj(obj)

        _obj = TaskTransitionDefinition.parse_obj({
            "from_state": obj.get("fromState"),
            "to_state": obj.get("toState"),
            "trigger": obj.get("trigger"),
            "guard": obj.get("guard"),
            "action": obj.get("action"),
            "display_name": obj.get("displayName"),
            "description": obj.get("description"),
            "guard_description": obj.get("guardDescription"),
            "guard_condition_not_met_message": obj.get("guardConditionNotMetMessage")
        })
        return _obj
