# coding: utf-8

"""
    FINBOURNE Workflow API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictBool, StrictStr, constr, validator 
from lusid_workflow.models.read_only_states import ReadOnlyStates
from lusid_workflow.models.value_constraints import ValueConstraints

class TaskFieldDefinition(BaseModel):
    """
    Defines a Task Definition Field  # noqa: E501
    """
    name:  StrictStr = Field(...,alias="name", description="The name of this Field") 
    type:  StrictStr = Field(...,alias="type", description="The value type for the field. Available values are: \"String\", \"Decimal\", \"DateTime\", \"Boolean\")") 
    read_only_states: Optional[ReadOnlyStates] = Field(None, alias="readOnlyStates")
    value_constraints: Optional[ValueConstraints] = Field(None, alias="valueConstraints")
    display_name:  Optional[StrictStr] = Field(None,alias="displayName", description="Display name for field definition") 
    description:  Optional[StrictStr] = Field(None,alias="description", description="Description for field definition") 
    category:  Optional[StrictStr] = Field(None,alias="category", description="Category for field definition") 
    contains_url: Optional[StrictBool] = Field(None, alias="containsUrl", description="Field contains url")
    __properties = ["name", "type", "readOnlyStates", "valueConstraints", "displayName", "description", "category", "containsUrl"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TaskFieldDefinition:
        """Create an instance of TaskFieldDefinition from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of read_only_states
        if self.read_only_states:
            _dict['readOnlyStates'] = self.read_only_states.to_dict()
        # override the default output from pydantic by calling `to_dict()` of value_constraints
        if self.value_constraints:
            _dict['valueConstraints'] = self.value_constraints.to_dict()
        # set to None if display_name (nullable) is None
        # and __fields_set__ contains the field
        if self.display_name is None and "display_name" in self.__fields_set__:
            _dict['displayName'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if category (nullable) is None
        # and __fields_set__ contains the field
        if self.category is None and "category" in self.__fields_set__:
            _dict['category'] = None

        # set to None if contains_url (nullable) is None
        # and __fields_set__ contains the field
        if self.contains_url is None and "contains_url" in self.__fields_set__:
            _dict['containsUrl'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TaskFieldDefinition:
        """Create an instance of TaskFieldDefinition from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TaskFieldDefinition.parse_obj(obj)

        _obj = TaskFieldDefinition.parse_obj({
            "name": obj.get("name"),
            "type": obj.get("type"),
            "read_only_states": ReadOnlyStates.from_dict(obj.get("readOnlyStates")) if obj.get("readOnlyStates") is not None else None,
            "value_constraints": ValueConstraints.from_dict(obj.get("valueConstraints")) if obj.get("valueConstraints") is not None else None,
            "display_name": obj.get("displayName"),
            "description": obj.get("description"),
            "category": obj.get("category"),
            "contains_url": obj.get("containsUrl")
        })
        return _obj
