# coding: utf-8

"""
    FINBOURNE Workflow API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictInt, StrictStr 

class Stack(BaseModel):
    """
    Information pertaining to the Tasks Stack if one is present  # noqa: E501
    """
    member_added_as_at: Optional[datetime] = Field(None, alias="memberAddedAsAt", description="When the Task was added to the Stack")
    stack_opened_as_at: Optional[datetime] = Field(None, alias="stackOpenedAsAt", description="When the Stack was opened")
    stack_closed_as_at: Optional[datetime] = Field(None, alias="stackClosedAsAt", description="When the Stack was closed")
    stack_membership_type:  Optional[StrictStr] = Field(None,alias="stackMembershipType", description="Whether the task is the Lead task of the Stack or a Member within the Stack") 
    stack_status:  Optional[StrictStr] = Field(None,alias="stackStatus", description="Status of the Stack (Open/Closed)") 
    lead_task_id:  Optional[StrictStr] = Field(None,alias="leadTaskId", description="ID of the Lead Task") 
    lead_task_state:  Optional[StrictStr] = Field(None,alias="leadTaskState", description="State of the Lead Task") 
    tasks_in_stack: Optional[StrictInt] = Field(None, alias="tasksInStack", description="Number of Tasks in the Stack")
    __properties = ["memberAddedAsAt", "stackOpenedAsAt", "stackClosedAsAt", "stackMembershipType", "stackStatus", "leadTaskId", "leadTaskState", "tasksInStack"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Stack:
        """Create an instance of Stack from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if stack_closed_as_at (nullable) is None
        # and __fields_set__ contains the field
        if self.stack_closed_as_at is None and "stack_closed_as_at" in self.__fields_set__:
            _dict['stackClosedAsAt'] = None

        # set to None if stack_membership_type (nullable) is None
        # and __fields_set__ contains the field
        if self.stack_membership_type is None and "stack_membership_type" in self.__fields_set__:
            _dict['stackMembershipType'] = None

        # set to None if stack_status (nullable) is None
        # and __fields_set__ contains the field
        if self.stack_status is None and "stack_status" in self.__fields_set__:
            _dict['stackStatus'] = None

        # set to None if lead_task_state (nullable) is None
        # and __fields_set__ contains the field
        if self.lead_task_state is None and "lead_task_state" in self.__fields_set__:
            _dict['leadTaskState'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Stack:
        """Create an instance of Stack from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Stack.parse_obj(obj)

        _obj = Stack.parse_obj({
            "member_added_as_at": obj.get("memberAddedAsAt"),
            "stack_opened_as_at": obj.get("stackOpenedAsAt"),
            "stack_closed_as_at": obj.get("stackClosedAsAt"),
            "stack_membership_type": obj.get("stackMembershipType"),
            "stack_status": obj.get("stackStatus"),
            "lead_task_id": obj.get("leadTaskId"),
            "lead_task_state": obj.get("leadTaskState"),
            "tasks_in_stack": obj.get("tasksInStack")
        })
        return _obj
