# coding: utf-8

"""
    FINBOURNE Workflow API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, conlist, constr 
from lusid_workflow.models.calendar_reference import CalendarReference

class ScheduleMatchingPatternContext(BaseModel):
    """
    Context for a Schedule Matching Pattern  # noqa: E501
    """
    time_zone:  StrictStr = Field(...,alias="timeZone", description="The time zone to use") 
    holiday_calendars: Optional[conlist(CalendarReference)] = Field(None, alias="holidayCalendars", description="References to any Holiday Calendars to use")
    __properties = ["timeZone", "holidayCalendars"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ScheduleMatchingPatternContext:
        """Create an instance of ScheduleMatchingPatternContext from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in holiday_calendars (list)
        _items = []
        if self.holiday_calendars:
            for _item in self.holiday_calendars:
                if _item:
                    _items.append(_item.to_dict())
            _dict['holidayCalendars'] = _items
        # set to None if holiday_calendars (nullable) is None
        # and __fields_set__ contains the field
        if self.holiday_calendars is None and "holiday_calendars" in self.__fields_set__:
            _dict['holidayCalendars'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ScheduleMatchingPatternContext:
        """Create an instance of ScheduleMatchingPatternContext from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ScheduleMatchingPatternContext.parse_obj(obj)

        _obj = ScheduleMatchingPatternContext.parse_obj({
            "time_zone": obj.get("timeZone"),
            "holiday_calendars": [CalendarReference.from_dict(_item) for _item in obj.get("holidayCalendars")] if obj.get("holidayCalendars") is not None else None
        })
        return _obj
