# coding: utf-8

"""
    FINBOURNE Workflow API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictInt, conlist 
from lusid_workflow.models.parameter_value import ParameterValue

class RunWorkerRequest(BaseModel):
    """
    Request to Create a new worker  # noqa: E501
    """
    parameters: conlist(ParameterValue) = Field(..., description="The Parameter and their values.")
    worker_timeout: Optional[StrictInt] = Field(None, alias="workerTimeout", description="The timeout in seconds for the worker")
    __properties = ["parameters", "workerTimeout"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RunWorkerRequest:
        """Create an instance of RunWorkerRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in parameters (list)
        _items = []
        if self.parameters:
            for _item in self.parameters:
                if _item:
                    _items.append(_item.to_dict())
            _dict['parameters'] = _items
        # set to None if worker_timeout (nullable) is None
        # and __fields_set__ contains the field
        if self.worker_timeout is None and "worker_timeout" in self.__fields_set__:
            _dict['workerTimeout'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RunWorkerRequest:
        """Create an instance of RunWorkerRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RunWorkerRequest.parse_obj(obj)

        _obj = RunWorkerRequest.parse_obj({
            "parameters": [ParameterValue.from_dict(_item) for _item in obj.get("parameters")] if obj.get("parameters") is not None else None,
            "worker_timeout": obj.get("workerTimeout")
        })
        return _obj
