# coding: utf-8

"""
    FINBOURNE Workflow API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict
from pydantic.v1 import StrictStr, Field, BaseModel, Field, constr 
from lusid_workflow.models.date_regularity import DateRegularity
from lusid_workflow.models.time_constraints import TimeConstraints

class RecurrencePattern(BaseModel):
    """
    The Recurrence Pattern  # noqa: E501
    """
    time_constraints: TimeConstraints = Field(..., alias="timeConstraints")
    date_regularity: DateRegularity = Field(..., alias="dateRegularity")
    business_day_adjustment:  StrictStr = Field(...,alias="businessDayAdjustment", description="The Business Day Adjustment") 
    __properties = ["timeConstraints", "dateRegularity", "businessDayAdjustment"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RecurrencePattern:
        """Create an instance of RecurrencePattern from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of time_constraints
        if self.time_constraints:
            _dict['timeConstraints'] = self.time_constraints.to_dict()
        # override the default output from pydantic by calling `to_dict()` of date_regularity
        if self.date_regularity:
            _dict['dateRegularity'] = self.date_regularity.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RecurrencePattern:
        """Create an instance of RecurrencePattern from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RecurrencePattern.parse_obj(obj)

        _obj = RecurrencePattern.parse_obj({
            "time_constraints": TimeConstraints.from_dict(obj.get("timeConstraints")) if obj.get("timeConstraints") is not None else None,
            "date_regularity": DateRegularity.from_dict(obj.get("dateRegularity")) if obj.get("dateRegularity") is not None else None,
            "business_day_adjustment": obj.get("businessDayAdjustment")
        })
        return _obj
