# coding: utf-8

"""
    FINBOURNE Workflow API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional
from pydantic.v1 import BaseModel, Field, StrictStr, ValidationError, validator
from lusid_workflow.models.day_regularity import DayRegularity
from lusid_workflow.models.relative_month_regularity import RelativeMonthRegularity
from lusid_workflow.models.specific_month_regularity import SpecificMonthRegularity
from lusid_workflow.models.week_regularity import WeekRegularity
from lusid_workflow.models.year_regularity import YearRegularity
from typing import Union, Any, List, TYPE_CHECKING
from pydantic.v1 import StrictStr, Field

DATEREGULARITY_ONE_OF_SCHEMAS = ["DayRegularity", "RelativeMonthRegularity", "SpecificMonthRegularity", "WeekRegularity", "YearRegularity"]

class DateRegularity(BaseModel):
    """
    A Date Regularity
    """
    # data type: DayRegularity
    oneof_schema_1_validator: Optional[DayRegularity] = None
    # data type: RelativeMonthRegularity
    oneof_schema_2_validator: Optional[RelativeMonthRegularity] = None
    # data type: SpecificMonthRegularity
    oneof_schema_3_validator: Optional[SpecificMonthRegularity] = None
    # data type: WeekRegularity
    oneof_schema_4_validator: Optional[WeekRegularity] = None
    # data type: YearRegularity
    oneof_schema_5_validator: Optional[YearRegularity] = None
    if TYPE_CHECKING:
        actual_instance: Union[DayRegularity, RelativeMonthRegularity, SpecificMonthRegularity, WeekRegularity, YearRegularity]
    else:
        actual_instance: Any
    one_of_schemas: List[str] = Field(DATEREGULARITY_ONE_OF_SCHEMAS, const=True)

    class Config:
        validate_assignment = True

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = DateRegularity.construct()
        error_messages = []
        match = 0
        matchclass = ""
        # validate data type: DayRegularity
        if not isinstance(v, DayRegularity):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DayRegularity`")
        else:
            match += 1
            matchclass = matchclass + " DayRegularity"
        # validate data type: RelativeMonthRegularity
        if not isinstance(v, RelativeMonthRegularity):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RelativeMonthRegularity`")
        else:
            match += 1
            matchclass = matchclass + " RelativeMonthRegularity"
        # validate data type: SpecificMonthRegularity
        if not isinstance(v, SpecificMonthRegularity):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SpecificMonthRegularity`")
        else:
            match += 1
            matchclass = matchclass + " SpecificMonthRegularity"
        # validate data type: WeekRegularity
        if not isinstance(v, WeekRegularity):
            error_messages.append(f"Error! Input type `{type(v)}` is not `WeekRegularity`")
        else:
            match += 1
            matchclass = matchclass + " WeekRegularity"
        # validate data type: YearRegularity
        if not isinstance(v, YearRegularity):
            error_messages.append(f"Error! Input type `{type(v)}` is not `YearRegularity`")
        else:
            match += 1
            matchclass = matchclass + " YearRegularity"
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in DateRegularity with oneOf schemas: DayRegularity, RelativeMonthRegularity, SpecificMonthRegularity, WeekRegularity, YearRegularity. Details: Matched classes " + matchclass)
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in DateRegularity with oneOf schemas: DayRegularity, RelativeMonthRegularity, SpecificMonthRegularity, WeekRegularity, YearRegularity. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: dict) -> DateRegularity:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> DateRegularity:
        """Returns the object represented by the json string"""
        instance = DateRegularity.construct()
        error_messages = []
        match = 0
        matchclass = ""
        

        # deserialize data into DayRegularity
        try:
            instance.actual_instance = DayRegularity.from_json(json_str)
            match += 1
            matchclass =matchclass + " DayRegularity"
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into RelativeMonthRegularity
        try:
            instance.actual_instance = RelativeMonthRegularity.from_json(json_str)
            match += 1
            matchclass =matchclass + " RelativeMonthRegularity"
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SpecificMonthRegularity
        try:
            instance.actual_instance = SpecificMonthRegularity.from_json(json_str)
            match += 1
            matchclass =matchclass + " SpecificMonthRegularity"
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into WeekRegularity
        try:
            instance.actual_instance = WeekRegularity.from_json(json_str)
            match += 1
            matchclass =matchclass + " WeekRegularity"
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into YearRegularity
        try:
            instance.actual_instance = YearRegularity.from_json(json_str)
            match += 1
            matchclass =matchclass + " YearRegularity"
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into DateRegularity with oneOf schemas: DayRegularity, RelativeMonthRegularity, SpecificMonthRegularity, WeekRegularity, YearRegularity. Matches: "+matchclass+", Details: " + ", ".join(error_messages) + ", JSON: " + json_str)
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into DateRegularity with oneOf schemas: DayRegularity, RelativeMonthRegularity, SpecificMonthRegularity, WeekRegularity, YearRegularity. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        to_json = getattr(self.actual_instance, "to_json", None)
        if callable(to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> dict:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        to_dict = getattr(self.actual_instance, "to_dict", None)
        if callable(to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

        def __str__(self):
            """For `print` and `pprint`"""
            return pprint.pformat(self.dict(by_alias=False))
    
        def __repr__(self):
            """For `print` and `pprint`"""
            return self.to_str()
    
        def to_str(self) -> str:
            """Returns the string representation of the model using alias"""
            return pprint.pformat(self.dict(by_alias=True))
