# coding: utf-8

"""
    FINBOURNE Workflow API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictInt, constr 

class ChangeItem(BaseModel):
    """
    Defines a change that occured to a Task  # noqa: E501
    """
    as_at_modified: datetime = Field(..., alias="asAtModified", description="The AsAt time of the change")
    user_id_modified:  StrictStr = Field(...,alias="userIdModified", description="The User ID that performed the change") 
    request_id_modified:  StrictStr = Field(...,alias="requestIdModified", description="The Request ID of the request that caused the change") 
    as_at_version_number: StrictInt = Field(..., alias="asAtVersionNumber", description="The AsAt Version number")
    action:  StrictStr = Field(...,alias="action", description="The Action that resulted in the change") 
    attribute_name:  StrictStr = Field(...,alias="attributeName", description="The name of the attribute that has been change") 
    previous_value: Optional[Any] = Field(None, alias="previousValue", description="The value of the attribute prior to the change")
    new_value: Optional[Any] = Field(..., alias="newValue", description="The value of the attribute following the change")
    __properties = ["asAtModified", "userIdModified", "requestIdModified", "asAtVersionNumber", "action", "attributeName", "previousValue", "newValue"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ChangeItem:
        """Create an instance of ChangeItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if previous_value (nullable) is None
        # and __fields_set__ contains the field
        if self.previous_value is None and "previous_value" in self.__fields_set__:
            _dict['previousValue'] = None

        # set to None if new_value (nullable) is None
        # and __fields_set__ contains the field
        if self.new_value is None and "new_value" in self.__fields_set__:
            _dict['newValue'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ChangeItem:
        """Create an instance of ChangeItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ChangeItem.parse_obj(obj)

        _obj = ChangeItem.parse_obj({
            "as_at_modified": obj.get("asAtModified"),
            "user_id_modified": obj.get("userIdModified"),
            "request_id_modified": obj.get("requestIdModified"),
            "as_at_version_number": obj.get("asAtVersionNumber"),
            "action": obj.get("action"),
            "attribute_name": obj.get("attributeName"),
            "previous_value": obj.get("previousValue"),
            "new_value": obj.get("newValue")
        })
        return _obj
