# coding: utf-8

"""
    FINBOURNE Workflow API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, conlist 
from lusid_workflow.models.update_task_with_id_and_trigger_request import UpdateTaskWithIdAndTriggerRequest

class BatchUpdateTasksRequest(BaseModel):
    """
    A request to update multiple Tasks  # noqa: E501
    """
    update_tasks: Optional[conlist(UpdateTaskWithIdAndTriggerRequest)] = Field(None, alias="updateTasks", description="A Dictionary of task IDs to UpdateTaskRequest")
    __properties = ["updateTasks"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BatchUpdateTasksRequest:
        """Create an instance of BatchUpdateTasksRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in update_tasks (list)
        _items = []
        if self.update_tasks:
            for _item in self.update_tasks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['updateTasks'] = _items
        # set to None if update_tasks (nullable) is None
        # and __fields_set__ contains the field
        if self.update_tasks is None and "update_tasks" in self.__fields_set__:
            _dict['updateTasks'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BatchUpdateTasksRequest:
        """Create an instance of BatchUpdateTasksRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BatchUpdateTasksRequest.parse_obj(obj)

        _obj = BatchUpdateTasksRequest.parse_obj({
            "update_tasks": [UpdateTaskWithIdAndTriggerRequest.from_dict(_item) for _item in obj.get("updateTasks")] if obj.get("updateTasks") is not None else None
        })
        return _obj
