# coding: utf-8

"""
    FINBOURNE Workflow API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictStr, constr 

class ActionLogItem(BaseModel):
    """
    A log item for a given Action Log  # noqa: E501
    """
    timestamp: datetime = Field(..., description="The timestamp of the log item")
    log_type:  StrictStr = Field(...,alias="logType", description="The type of log item") 
    details:  Optional[StrictStr] = Field(None,alias="details", description="The details of the log item") 
    __properties = ["timestamp", "logType", "details"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ActionLogItem:
        """Create an instance of ActionLogItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if details (nullable) is None
        # and __fields_set__ contains the field
        if self.details is None and "details" in self.__fields_set__:
            _dict['details'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ActionLogItem:
        """Create an instance of ActionLogItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ActionLogItem.parse_obj(obj)

        _obj = ActionLogItem.parse_obj({
            "timestamp": obj.get("timestamp"),
            "log_type": obj.get("logType"),
            "details": obj.get("details")
        })
        return _obj
