# coding: utf-8

"""
    FINBOURNE Workflow API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, conlist, constr, validator 
from lusid_workflow.models.action_log_item import ActionLogItem
from lusid_workflow.models.action_log_origin import ActionLogOrigin

class ActionLog(BaseModel):
    """
    An Action Log contains the processing history of an Action  # noqa: E501
    """
    id:  StrictStr = Field(...,alias="id", description="Unique identifier of the Action") 
    origin: ActionLogOrigin = Field(...)
    action_type:  StrictStr = Field(...,alias="actionType", description="The type of the Action") 
    run_as_user_id:  Optional[StrictStr] = Field(None,alias="runAsUserId", description="The ID of the user that the Action was performed by.  If not specified, the actions were performed by the \"current user\".") 
    logged_items: conlist(ActionLogItem) = Field(..., alias="loggedItems", description="The logged items for this Action")
    __properties = ["id", "origin", "actionType", "runAsUserId", "loggedItems"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ActionLog:
        """Create an instance of ActionLog from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of origin
        if self.origin:
            _dict['origin'] = self.origin.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in logged_items (list)
        _items = []
        if self.logged_items:
            for _item in self.logged_items:
                if _item:
                    _items.append(_item.to_dict())
            _dict['loggedItems'] = _items
        # set to None if run_as_user_id (nullable) is None
        # and __fields_set__ contains the field
        if self.run_as_user_id is None and "run_as_user_id" in self.__fields_set__:
            _dict['runAsUserId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ActionLog:
        """Create an instance of ActionLog from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ActionLog.parse_obj(obj)

        _obj = ActionLog.parse_obj({
            "id": obj.get("id"),
            "origin": ActionLogOrigin.from_dict(obj.get("origin")) if obj.get("origin") is not None else None,
            "action_type": obj.get("actionType"),
            "run_as_user_id": obj.get("runAsUserId"),
            "logged_items": [ActionLogItem.from_dict(_item) for _item in obj.get("loggedItems")] if obj.get("loggedItems") is not None else None
        })
        return _obj
