# climatemind-ontology-processing

The ontology is stored as an OWL file (a type of RDF/XML file) which we convert to a NetworkX Graph using
Owlready2 (a Python library for processing an ontology). These files handle all of the
processing and visualization for the ontology.

## How to Process the Ontology

### Do this your first time
Be sure git is installed on your computer first.

Then, install the package via pip install:
```
python3 -m pip install git+https://github.com/ClimateMind/climatemind-ontology-processing.git
```
Be sure you have installed all requirements first by doing: 
```
python3 -m pip install -r https://raw.githubusercontent.com/ClimateMind/climatemind-ontology-processing/main/requirements.txt
```

Now you're all set up and ready to roll!

**_SPECIAL NOTE_**: There are occasional updates to the repo. If you need to update the package run:
```
python3 -m pip install --upgrade git+https://github.com/ClimateMind/climatemind-ontology-processing.git
```

### Do this every time
1. Download a fresh copy of the ontology from web protege. Make sure it's the RDF/XML format (check the downloaded item has .owl at the end of it!).
2. When using the code as a package, be sure to `import ontology_processing.process_new_ontology_file`
3. Use the function `ontology_processing.process_new_ontology_file.processOntology(onto_path, output_folder_path)` where onto path is the path of the .owl ontology file and output_folder_path is the path to a folder for the output files to go into.
4. Check your output in your output folder. You should have a pickle file, a json file and a csv

You now have a fresh copy of the NetworkX graph to use for the climatemind-backend Flask app!



### Alternatively, if prefer not to use the code as a package installed using pip, then:
1. Download a fresh copy of the ontology from web protege. Make sure it's the RDF/XML format (check the downloaded item has .owl at the end of it!).
2. Clone the climatemind-ontology-processing directory to your local machine
3. Use the command line/terminal to navigate to the climatemind-ontology-processing directory
4. Create and activate a virtual env
MAC:
```
python3 -m venv venv
source venv/bin/activate
```
Windows:
```
python3 -m venv venv
cd venv\Scripts
activate
```
4. Install the dependencies
```
pip install -r requirements.txt
```
5. Navigate and change directory to climatemind-ontology-processing/ontology\_processing
6. Run scripts by running the following command in the command line 
`python process\_new\_ontology\_file.py OWL\_FILE\_PATH OUTPUT\_FOLDER\_PATH` 
where the OWL\_FILE\_PATH is replaced with the actual path to the .owl file you downloaded and OUTPUT\_FOLDER\_PATH is replaced with the path to an existing folder where the output files generated by the script can be saved to. Use the absolute path for Windows.
7. Check your output in your output folder. You should have a pickle file, a json file and a csv
8. Deactive the virtual environment (for Windows, remember cd venv\Scripts)
```
deactivate
```

You now have a fresh copy of the NetworkX graph to use for the climatemind-backend Flask app!



###For developers editing code for this repo and who need to install the source code but allow it to be editable for local development:
```
pip install -e <path>
```
