"""Dictionaries supporting conditions and phenotypes."""

import requests
import os

disease_text = {
    'DOID:0050589': 'inflammatory bowel disease',
    'DOID:9744': 'type 1 diabetes mellitus',
    'DOID:1287': 'cardiovascular system disease',
    'DOID:3393': 'coronary artery disease',
    'DOID:0060224': 'atrial fibrillation',
    'DOID:0014667': 'disease of metabolism',
    'DOID:10652': "Alzheimer's disease",
    'DOID:0060041': 'autism spectrum disorder',
    'DOID:2841': 'asthma',
    'DOID:5844': 'myocardial infarction',
    'DOID:1826': 'epilepsy',
    'DOID:630': 'genetic disease',
    'DOID:5419': 'schizophrenia',
    'DOID:12377': 'spinal muscular atrophy',
    'OMIM:613801': 'Retinitis pigmentosa-40',
    'OMIM:213300': 'Joubert syndrome 1',
    'OMIM:615780': 'Retinitis pigmentosa 69',
    'OMIM:613826': 'Leber congenital amaurosis 6',
    'OMIM:310200': 'Duchenne muscular dystrophy',
    'OMIM:617194': 'Lethal congenital contracture syndrome 11',
    'OMIM:105400': 'AMYOTROPHIC LATERAL SCLEROSIS 1; ALS1',
    'OMIM:108120': 'ARTHROGRYPOSIS, DISTAL, TYPE 1A; DA1A',
    'OMIM:114300': 'ARTHROGRYPOSIS, DISTAL, TYPE 3; DA3',
    'OMIM:115195': 'CARDIOMYOPATHY, FAMILIAL HYPERTROPHIC, 2; CMH2',
    'OMIM:115196': 'CARDIOMYOPATHY, FAMILIAL HYPERTROPHIC, 3; CMH3',
    'OMIM:115197': 'CARDIOMYOPATHY, FAMILIAL HYPERTROPHIC, 4; CMH4',
    'OMIM:115200': 'CARDIOMYOPATHY, DILATED, 1A; CMD1A',
    'OMIM:117000': 'CENTRAL CORE DISEASE OF MUSCLE; CCD',
    'OMIM:117360': 'SPINOCEREBELLAR ATAXIA 29; SCA29',
    'OMIM:119530': 'OROFACIAL CLEFT 1; OFC1',
    'OMIM:122470': 'CORNELIA DE LANGE SYNDROME 1; CDLS1',
    'OMIM:130600': 'ELLIPTOCYTOSIS 2; EL2',
    'OMIM:135900': 'COFFIN-SIRIS SYNDROME 1; CSS1',
    'OMIM:136140': 'FLOATING-HARBOR SYNDROME; FLHS',
    'OMIM:137920': 'RENAL CYSTS AND DIABETES SYNDROME; RCAD',
    'OMIM:139090': 'GRAY PLATELET SYNDROME; GPS',
    'OMIM:139210': 'MYHRE SYNDROME; MYHRS',
    'OMIM:143095': 'SPONDYLOEPIPHYSEAL DYSPLASIA WITH CONGENITAL JOINT DISLOCATIONS; SEDCJD',
    'OMIM:143465': 'ATTENTION DEFICIT-HYPERACTIVITY DISORDER; ADHD',
    'OMIM:147891': 'ISCHIOCOXOPODOPATELLAR SYNDROME WITH OR WITHOUT PULMONARY ARTERIAL HYPERTENSION; ICPPS',
    'OMIM:147920': 'KABUKI SYNDROME 1; KABUK1',
    'OMIM:148050': 'KBG SYNDROME; KBGS',
    'OMIM:149400': 'HYPEREKPLEXIA 1; HKPX1',
    'OMIM:152950': 'MICROCEPHALY WITH OR WITHOUT CHORIORETINOPATHY, LYMPHEDEMA, OR MENTAL RETARDATION; MCLMR',
    'OMIM:153670': 'BERNARD-SOULIER SYNDROME, TYPE A2, AUTOSOMAL DOMINANT; BSSA2',
    'OMIM:154400': 'ACROFACIAL DYSOSTOSIS 1, NAGER TYPE; AFD1',
    'OMIM:154700': 'MARFAN SYNDROME; MFS',
    'OMIM:155310': 'VISCERAL MYOPATHY; VSCM',
    'OMIM:158590': 'NEURONOPATHY, DISTAL HEREDITARY MOTOR, TYPE IIA; HMN2A',
    'OMIM:158810': 'BETHLEM MYOPATHY 1; BTHLM1',
    'OMIM:159550': 'ATAXIA-PANCYTOPENIA SYNDROME; ATXPC',
    'OMIM:160150': 'MYOPATHY, CENTRONUCLEAR, 1; CNM1',
    'OMIM:160500': 'MYOPATHY, DISTAL, 1; MPD1',
    'OMIM:160800': 'MYOTONIA CONGENITA, AUTOSOMAL DOMINANT',
    'OMIM:160900': 'MYOTONIC DYSTROPHY 1; DM1',
    'OMIM:161800': 'NEMALINE MYOPATHY 3; NEM3',
    'OMIM:163950': 'NOONAN SYNDROME 1; NS1',
    'OMIM:178110': 'CONTRACTURES, PTERYGIA, AND SPONDYLOCARPOTARSAL FUSION SYNDROME 1A; CPSFS1A',
    'OMIM:178500': 'PULMONARY FIBROSIS, IDIOPATHIC; IPF',
    'OMIM:180100': 'RETINITIS PIGMENTOSA 1; RP1',
    'OMIM:180849': 'RUBINSTEIN-TAYBI SYNDROME 1; RSTS1',
    'OMIM:181430': 'SCAPULOPERONEAL MYOPATHY, MYH7-RELATED; SPMM',
    'OMIM:182601': 'SPASTIC PARAPLEGIA 4, AUTOSOMAL DOMINANT; SPG4',
    'OMIM:188000': 'THROMBOCYTOPENIA 2; THC2',
    'OMIM:191480': 'UNCOMBABLE HAIR SYNDROME 1; UHS1',
    'OMIM:203800': 'ALSTROM SYNDROME; ALMS',
    'OMIM:204200': 'CEROID LIPOFUSCINOSIS, NEURONAL, 3; CLN3',
    'OMIM:204500': 'CEROID LIPOFUSCINOSIS, NEURONAL, 2; CLN2',
    'OMIM:205100': 'AMYOTROPHIC LATERAL SCLEROSIS 2, JUVENILE; ALS2',
    'OMIM:206900': 'MICROPHTHALMIA, SYNDROMIC 3; MCOPS3',
    'OMIM:208900': 'ATAXIA-TELANGIECTASIA; AT',
    'OMIM:209850': 'AUTISM',
    'OMIM:209900': 'BARDET-BIEDL SYNDROME 1; BBS1',
    'OMIM:210000': 'BEHR SYNDROME; BEHRS',
    'OMIM:210720': 'MICROCEPHALIC OSTEODYSPLASTIC PRIMORDIAL DWARFISM, TYPE II; MOPD2',
    'OMIM:210900': 'BLOOM SYNDROME; BLM',
    'OMIM:212065': 'CONGENITAL DISORDER OF GLYCOSYLATION, TYPE Ia; CDG1A',
    'OMIM:212066': 'CONGENITAL DISORDER OF GLYCOSYLATION, TYPE IIa; CDG2A',
    'OMIM:214500': 'CHEDIAK-HIGASHI SYNDROME; CHS',
    'OMIM:214800': 'CHARGE SYNDROME',
    'OMIM:215500': 'CHOROIDAL DYSTROPHY, CENTRAL AREOLAR, 1; CACD1',
    'OMIM:216400': 'COCKAYNE SYNDROME A; CSA',
    'OMIM:216550': 'COHEN SYNDROME; COH1',
    'OMIM:217080': 'JALILI SYNDROME',
    'OMIM:217980': 'CORPUS CALLOSUM, AGENESIS OF, WITH FACIAL ANOMALIES AND ROBIN SEQUENCE',
    'OMIM:218340': 'TEMTAMY SYNDROME; TEMTYS',
    'OMIM:219200': 'CUTIS LAXA, AUTOSOMAL RECESSIVE, TYPE IIA; ARCL2A',
    'OMIM:224050': 'CEREBELLAR ATAXIA, MENTAL RETARDATION, AND DYSEQUILIBRIUM SYNDROME 1; CAMRQ1',
    'OMIM:224690': 'MEIER-GORLIN SYNDROME 1; MGORS1',
    'OMIM:225753': 'PONTOCEREBELLAR HYPOPLASIA, TYPE 4; PCH4',
    'OMIM:225790': 'PROLIFERATIVE VASCULOPATHY AND HYDRANENCEPHALY-HYDROCEPHALY SYNDROME; PVHH',
    'OMIM:227650': 'FANCONI ANEMIA, COMPLEMENTATION GROUP A; FANCA',
    'OMIM:229600': 'FRUCTOSE INTOLERANCE, HEREDITARY; HFI',
    'OMIM:230000': 'FUCOSIDOSIS',
    'OMIM:230500': 'GM1-GANGLIOSIDOSIS, TYPE I',
    'OMIM:232300': 'GLYCOGEN STORAGE DISEASE II; GSD2',
    'OMIM:232600': 'GLYCOGEN STORAGE DISEASE V; GSD5',
    'OMIM:234200': 'NEURODEGENERATION WITH BRAIN IRON ACCUMULATION 1; NBIA1',
    'OMIM:234500': 'HARTNUP DISORDER; HND',
    'OMIM:236000': 'LYMPHOMA, HODGKIN, CLASSIC; CHL',
    'OMIM:236600': 'HYDROCEPHALUS, CONGENITAL, 1; HYC1',
    'OMIM:236792': 'L-2-HYDROXYGLUTARIC ACIDURIA; L2HGA',
    'OMIM:243310': 'BARAITSER-WINTER SYNDROME 1; BRWS1',
    'OMIM:244450': 'KAUFMAN OCULOCEREBROFACIAL SYNDROME; KOS',
    'OMIM:245200': 'KRABBE DISEASE',
    'OMIM:245359': 'missing',
    'OMIM:248200': 'STARGARDT DISEASE 1; STGD1',
    'OMIM:248700': 'MARDEN-WALKER SYNDROME; MWKS',
    'OMIM:249000': 'MECKEL SYNDROME, TYPE 1; MKS1',
    'OMIM:249900': 'METACHROMATIC LEUKODYSTROPHY DUE TO SAPOSIN B DEFICIENCY',
    'OMIM:250100': 'METACHROMATIC LEUKODYSTROPHY; MLD',
    'OMIM:250620': '3-HYDROXYISOBUTYRYL-CoA HYDROLASE DEFICIENCY; HIBCHD',
    'OMIM:251200': 'MICROCEPHALY 1, PRIMARY, AUTOSOMAL RECESSIVE; MCPH1',
    'OMIM:251260': 'NIJMEGEN BREAKAGE SYNDROME; NBS',
    'OMIM:251280': 'DIENCEPHALIC-MESENCEPHALIC JUNCTION DYSPLASIA SYNDROME 1; DMJDS1',
    'OMIM:251290': 'PSEUDO-TORCH SYNDROME 1; PTORCH1',
    'OMIM:251300': 'GALLOWAY-MOWAT SYNDROME 1; GAMOS1',
    'OMIM:252010': 'MITOCHONDRIAL COMPLEX I DEFICIENCY, NUCLEAR TYPE 1; MC1DN1',
    'OMIM:252160': 'MOLYBDENUM COFACTOR DEFICIENCY, COMPLEMENTATION GROUP B; MOCODB',
    'OMIM:252920': 'MUCOPOLYSACCHARIDOSIS, TYPE IIIB; MPS3B',
    'OMIM:253250': 'MULIBREY NANISM',
    'OMIM:253600': 'MUSCULAR DYSTROPHY, LIMB-GIRDLE, AUTOSOMAL RECESSIVE 1; LGMDR1',
    'OMIM:253601': 'MUSCULAR DYSTROPHY, LIMB-GIRDLE, AUTOSOMAL RECESSIVE 2; LGMDR2',
    'OMIM:253700': 'MUSCULAR DYSTROPHY, LIMB-GIRDLE, AUTOSOMAL RECESSIVE 5; LGMDR5',
    'OMIM:254090': 'ULLRICH CONGENITAL MUSCULAR DYSTROPHY 1; UCMD1',
    'OMIM:254110': 'MUSCULAR DYSTROPHY, LIMB-GIRDLE, AUTOSOMAL RECESSIVE 8; LGMDR8',
    'OMIM:254300': 'MYASTHENIC SYNDROME, CONGENITAL, 10; CMS10',
    'OMIM:254780': 'MYOCLONIC EPILEPSY OF LAFORA',
    'OMIM:254940': 'CAREY-FINEMAN-ZITER SYNDROME; CFZS',
    'OMIM:255310': 'MYOPATHY, CONGENITAL, WITH FIBER-TYPE DISPROPORTION; CFTD',
    'OMIM:255320': 'MINICORE MYOPATHY WITH EXTERNAL OPHTHALMOPLEGIA',
    'OMIM:255800': 'SCHWARTZ-JAMPEL SYNDROME, TYPE 1; SJS1',
    'OMIM:256000': 'LEIGH SYNDROME; LS',
    'OMIM:256300': 'NEPHROTIC SYNDROME, TYPE 1; NPHS1',
    'OMIM:256600': 'NEURODEGENERATION WITH BRAIN IRON ACCUMULATION 2A; NBIA2A',
    'OMIM:256700': 'NEUROBLASTOMA, SUSCEPTIBILITY TO, 1; NBLST1',
    'OMIM:256730': 'CEROID LIPOFUSCINOSIS, NEURONAL, 1; CLN1',
    'OMIM:256731': 'CEROID LIPOFUSCINOSIS, NEURONAL, 5; CLN5',
    'OMIM:256800': 'INSENSITIVITY TO PAIN, CONGENITAL, WITH ANHIDROSIS; CIPA',
    'OMIM:256850': 'GIANT AXONAL NEUROPATHY 1, AUTOSOMAL RECESSIVE; GAN1',
    'OMIM:257220': 'NIEMANN-PICK DISEASE, TYPE C1; NPC1',
    'OMIM:257320': 'LISSENCEPHALY 2; LIS2',
    'OMIM:260400': 'SHWACHMAN-DIAMOND SYNDROME 1; SDS1',
    'OMIM:260565': 'PEHO SYNDROME; PEHO',
    'OMIM:261630': 'HYPERPHENYLALANINEMIA, BH4-DEFICIENT, C; HPABH4C',
    'OMIM:262500': 'LARON SYNDROME',
    'OMIM:263200': 'POLYCYSTIC KIDNEY DISEASE 4 WITH OR WITHOUT POLYCYSTIC LIVER DISEASE; PKD4',
    'OMIM:265000': 'MULTIPLE PTERYGIUM SYNDROME, ESCOBAR VARIANT; EVMPS',
    'OMIM:266100': 'EPILEPSY, PYRIDOXINE-DEPENDENT; EPD',
    'OMIM:266265': 'CONGENITAL DISORDER OF GLYCOSYLATION, TYPE IIc; CDG2C',
    'OMIM:266500': 'REFSUM DISEASE, CLASSIC',
    'OMIM:266510': 'PEROXISOME BIOGENESIS DISORDER 3B; PBD3B',
    'OMIM:268800': 'SANDHOFF DISEASE',
    'OMIM:270200': 'SJOGREN-LARSSON SYNDROME; SLS',
    'OMIM:270800': 'SPASTIC PARAPLEGIA 5A, AUTOSOMAL RECESSIVE; SPG5A',
    'OMIM:271900': 'CANAVAN DISEASE',
    'OMIM:272800': 'TAY-SACHS DISEASE; TSD',
    'OMIM:273300': 'TESTICULAR GERM CELL TUMOR; TGCT',
    'OMIM:274000': 'THROMBOCYTOPENIA-ABSENT RADIUS SYNDROME; TAR',
    'OMIM:276901': 'USHER SYNDROME, TYPE IIA; USH2A',
    'OMIM:277470': 'PONTOCEREBELLAR HYPOPLASIA, TYPE 2A; PCH2A',
    'OMIM:300029': 'RETINITIS PIGMENTOSA 3; RP3',
    'OMIM:300067': 'LISSENCEPHALY, X-LINKED, 1; LISX1',
    'OMIM:300088': 'DEVELOPMENTAL AND EPILEPTIC ENCEPHALOPATHY 9; DEE9',
    'OMIM:300100': 'ADRENOLEUKODYSTROPHY; ALD',
    'OMIM:300376': 'MUSCULAR DYSTROPHY, BECKER TYPE; BMD',
    'OMIM:300387': 'MENTAL RETARDATION, X-LINKED 63; MRX63',
    'OMIM:300476': 'CONE-ROD DYSTROPHY, X-LINKED, 3; CORDX3',
    'OMIM:300486': 'MENTAL RETARDATION, X-LINKED, WITH CEREBELLAR HYPOPLASIA AND DISTINCTIVE FACIAL APPEARANCE',
    'OMIM:300495': 'AUTISM, SUSCEPTIBILITY TO, X-LINKED 2; AUTSX2',
    'OMIM:300523': 'ALLAN-HERNDON-DUDLEY SYNDROME; AHDS',
    'OMIM:300534': 'MENTAL RETARDATION, X-LINKED, SYNDROMIC, CLAES-JENSEN TYPE; MRXSCJ',
    'OMIM:300695': 'SCAPULOPERONEAL MYOPATHY, X-LINKED DOMINANT; SPM',
    'OMIM:300749': 'MENTAL RETARDATION AND MICROCEPHALY WITH PONTINE AND CEREBELLAR HYPOPLASIA; MICPCH',
    'OMIM:300804': 'JOUBERT SYNDROME 10; JBTS10',
    'OMIM:300881': 'MOVED TO 615777',
    'OMIM:300882': 'CORNELIA DE LANGE SYNDROME 5; CDLS5',
    'OMIM:300894': 'NEURODEGENERATION WITH BRAIN IRON ACCUMULATION 5; NBIA5',
    'OMIM:300908': 'ANEMIA, NONSPHEROCYTIC HEMOLYTIC, DUE TO G6PD DEFICIENCY',
    'OMIM:300957': 'MENTAL RETARDATION, X-LINKED 12; MRX12',
    'OMIM:300958': 'INTELLECTUAL DEVELOPMENTAL DISORDER, X-LINKED, SYNDROMIC, SNIJDERS BLOK TYPE; MRXSSB',
    'OMIM:300966': 'MENTAL RETARDATION, X-LINKED, SYNDROMIC 33; MRXS33',
    'OMIM:300968': 'MENTAL RETARDATION, X-LINKED 99, SYNDROMIC, FEMALE-RESTRICTED; MRXS99F',
    'OMIM:300983': 'MENTAL RETARDATION, X-LINKED 104; MRX104',
    'OMIM:300986': 'MENTAL RETARDATION, X-LINKED, SYNDROMIC, BAIN TYPE; MRXSB',
    'OMIM:301050': 'ALPORT SYNDROME 1, X-LINKED; ATS1',
    'OMIM:301310': 'ANEMIA, SIDEROBLASTIC, AND SPINOCEREBELLAR ATAXIA; ASAT',
    'OMIM:304340': 'PETTIGREW SYNDROME; PGS',
    'OMIM:305100': 'ECTODERMAL DYSPLASIA 1, HYPOHIDROTIC, X-LINKED; XHED',
    'OMIM:308350': 'DEVELOPMENTAL AND EPILEPTIC ENCEPHALOPATHY 1; DEE1',
    'OMIM:309500': 'RENPENNING SYNDROME 1; RENS1',
    'OMIM:309541': 'METHYLMALONIC ACIDEMIA AND HOMOCYSTEINEMIA, cblX TYPE',
    'OMIM:309580': 'MENTAL RETARDATION-HYPOTONIC FACIES SYNDROME, X-LINKED, 1; MRXHF1',
    'OMIM:310468': 'NEPHROLITHIASIS, X-LINKED RECESSIVE, WITH RENAL FAILURE; XRN',
    'OMIM:311070': 'CHARCOT-MARIE-TOOTH DISEASE, X-LINKED RECESSIVE, 5; CMTX5',
    'OMIM:313850': 'THORACOABDOMINAL SYNDROME; THAS',
    'OMIM:314580': 'WIEACKER-WOLFF SYNDROME; WRWF',
    'OMIM:600059': 'RETINITIS PIGMENTOSA 13; RP13',
    'OMIM:600105': 'RETINITIS PIGMENTOSA 12; RP12',
    'OMIM:600118': 'WARBURG MICRO SYNDROME 1; WARBM1',
    'OMIM:600132': 'RETINITIS PIGMENTOSA 14; RP14',
    'OMIM:600138': 'RETINITIS PIGMENTOSA 11; RP11',
    'OMIM:600143': 'CEROID LIPOFUSCINOSIS, NEURONAL, 8; CLN8',
    'OMIM:600334': 'TIBIAL MUSCULAR DYSTROPHY, TARDIVE; TMD',
    'OMIM:600373': 'CODAS SYNDROME',
    'OMIM:600618': 'ETS VARIANT GENE 6; ETV6',
    'OMIM:600995': 'NEPHROTIC SYNDROME, TYPE 2; NPHS2',
    'OMIM:601088': 'AYME-GRIPP SYNDROME; AYGRP',
    'OMIM:601414': 'RETINITIS PIGMENTOSA 18; RP18',
    'OMIM:601419': 'MYOPATHY, MYOFIBRILLAR, 1; MFM1',
    'OMIM:601680': 'ARTHROGRYPOSIS, DISTAL, TYPE 2B1; DA2B1',
    'OMIM:601718': 'RETINITIS PIGMENTOSA 19; RP19',
    'OMIM:601780': 'CEROID LIPOFUSCINOSIS, NEURONAL, 6; CLN6',
    'OMIM:601815': 'PHOSPHOGLYCERATE DEHYDROGENASE DEFICIENCY; PHGDHD',
    'OMIM:601954': 'MUSCULAR DYSTROPHY, LIMB-GIRDLE, AUTOSOMAL RECESSIVE 7; LGMDR7',
    'OMIM:602482': 'AXENFELD-RIEGER SYNDROME, TYPE 3; RIEG3',
    'OMIM:602579': 'CONGENITAL DISORDER OF GLYCOSYLATION, TYPE Ib; CDG1B',
    'OMIM:602772': 'RETINITIS PIGMENTOSA 25; RP25',
    'OMIM:603511': 'MUSCULAR DYSTROPHY, LIMB-GIRDLE, AUTOSOMAL DOMINANT 1; LGMDD1',
    'OMIM:603896': 'LEUKOENCEPHALOPATHY WITH VANISHING WHITE MATTER; VWM',
    'OMIM:604004': 'MEGALENCEPHALIC LEUKOENCEPHALOPATHY WITH SUBCORTICAL CYSTS 1; MLC1',
    'OMIM:604116': 'CONE-ROD DYSTROPHY 3; CORD3',
    'OMIM:604273': 'MITOCHONDRIAL COMPLEX V (ATP SYNTHASE) DEFICIENCY, NUCLEAR TYPE 1; MC5DN1',
    'OMIM:604286': 'MUSCULAR DYSTROPHY, LIMB-GIRDLE, AUTOSOMAL RECESSIVE 4; LGMDR4',
    'OMIM:604317': 'MICROCEPHALY 2, PRIMARY, AUTOSOMAL RECESSIVE, WITH OR WITHOUT CORTICAL MALFORMATIONS; MCPH2',
    'OMIM:604360': 'SPASTIC PARAPLEGIA 11, AUTOSOMAL RECESSIVE; SPG11',
    'OMIM:604387': 'NEPHRONOPHTHISIS 3; NPHP3',
    'OMIM:604537': 'LEBER CONGENITAL AMAUROSIS 5; LCA5',
    'OMIM:604592': 'T CELL IMMUNE REGULATOR 1; TCIRG1',
    'OMIM:605130': 'WIEDEMANN-STEINER SYNDROME; WDSTS',
    'OMIM:605355': 'NEMALINE MYOPATHY 5; NEM5',
    'OMIM:605407': 'SEGAWA SYNDROME, AUTOSOMAL RECESSIVE',
    'OMIM:605637': 'MYOPATHY, PROXIMAL, WITH OPHTHALMOPLEGIA; MYPOP',
    'OMIM:605670': 'LATE-ONSET RETINAL DEGENERATION; LORD',
    'OMIM:605820': 'NONAKA MYOPATHY; NM',
    'OMIM:605899': 'GLYCINE ENCEPHALOPATHY; GCE',
    'OMIM:606068': 'RETINITIS PIGMENTOSA 28; RP28',
    'OMIM:606170': 'GENITOPATELLAR SYNDROME; GTPTS',
    'OMIM:606232': 'PHELAN-MCDERMID SYNDROME; PHMDS',
    'OMIM:606777': 'GLUT1 DEFICIENCY SYNDROME 1; GLUT1DS1',
    'OMIM:606854': 'POLYMICROGYRIA, BILATERAL FRONTOPARIETAL; BFPP',
    'OMIM:606966': 'NEPHRONOPHTHISIS 4; NPHP4',
    'OMIM:606996': 'SENIOR-LOKEN SYNDROME 4; SLSN4',
    'OMIM:607015': 'HURLER-SCHEIE SYNDROME',
    'OMIM:607155': 'MUSCULAR DYSTROPHY-DYSTROGLYCANOPATHY (LIMB-GIRDLE), TYPE C, 5; MDDGC5',
    'OMIM:607196': 'MICROCEPHALY, AMISH TYPE; MCPHA',
    'OMIM:607225': 'SPASTIC PARALYSIS, INFANTILE-ONSET ASCENDING; IAHSP',
    'OMIM:607426': 'COENZYME Q10 DEFICIENCY, PRIMARY, 1; COQ10D1',
    'OMIM:607432': 'LISSENCEPHALY 1; LIS1',
    'OMIM:607483': 'THIAMINE METABOLISM DYSFUNCTION SYNDROME 2 (BIOTIN- OR THIAMINE-RESPONSIVE TYPE); THMD2',
    'OMIM:607595': 'MOVED TO 175780',
    'OMIM:607596': 'PONTOCEREBELLAR HYPOPLASIA, TYPE 1A; PCH1A',
    'OMIM:607855': 'MUSCULAR DYSTROPHY, CONGENITAL MEROSIN-DEFICIENT, 1A; MDC1A',
    'OMIM:608027': 'PONTOCEREBELLAR HYPOPLASIA, TYPE 3; PCH3',
    'OMIM:608091': 'JOUBERT SYNDROME 2; JBTS2',
    'OMIM:608099': 'MUSCULAR DYSTROPHY, LIMB-GIRDLE, AUTOSOMAL RECESSIVE 3; LGMDR3',
    'OMIM:608133': 'RETINITIS PIGMENTOSA 7; RP7',
    'OMIM:608358': 'MYOPATHY, MYOSIN STORAGE, AUTOSOMAL DOMINANT; MSMA',
    'OMIM:608380': 'RETINITIS PIGMENTOSA 26; RP26',
    'OMIM:608393': 'MICROCEPHALY 6, PRIMARY, AUTOSOMAL RECESSIVE; MCPH6',
    'OMIM:608415': 'PROLONGED ELECTRORETINAL RESPONSE SUPPRESSION; PERRS',
    'OMIM:608423': 'MUSCULAR DYSTROPHY, LIMB-GIRDLE, AUTOSOMAL DOMINANT 2; LGMDD2',
    'OMIM:608540': 'CONGENITAL DISORDER OF GLYCOSYLATION, TYPE Ik; CDG1K',
    'OMIM:608629': 'JOUBERT SYNDROME 3; JBTS3',
    'OMIM:608643': 'AROMATIC L-AMINO ACID DECARBOXYLASE DEFICIENCY',
    'OMIM:608716': 'MICROCEPHALY 5, PRIMARY, AUTOSOMAL RECESSIVE; MCPH5',
    'OMIM:608804': 'LEUKODYSTROPHY, HYPOMYELINATING, 2; HLD2',
    'OMIM:608807': 'MUSCULAR DYSTROPHY, LIMB-GIRDLE, AUTOSOMAL RECESSIVE 10; LGMDR10',
    'OMIM:609033': 'POSTERIOR COLUMN ATAXIA WITH RETINITIS PIGMENTOSA; AXPC1',
    'OMIM:609056': 'SALT AND PEPPER DEVELOPMENTAL REGRESSION SYNDROME; SPDRS',
    'OMIM:609195': 'SPASTIC PARAPLEGIA 26, AUTOSOMAL RECESSIVE; SPG26',
    'OMIM:609200': 'MYOPATHY, MYOFIBRILLAR, 3; MFM3',
    'OMIM:609260': 'CHARCOT-MARIE-TOOTH DISEASE, AXONAL, AUTOSOMAL DOMINANT, TYPE 2A2A; CMT2A2A',
    'OMIM:609270': 'SPINOCEREBELLAR ATAXIA, AUTOSOMAL RECESSIVE 7; SCAR7',
    'OMIM:609304': 'DEVELOPMENTAL AND EPILEPTIC ENCEPHALOPATHY 3; DEE3',
    'OMIM:609524': 'MYOPATHY, MYOFIBRILLAR, 5; MFM5',
    'OMIM:609560': 'MITOCHONDRIAL DNA DEPLETION SYNDROME 2 (MYOPATHIC TYPE); MTDPS2',
    'OMIM:609923': 'RETINITIS PIGMENTOSA 31; RP31',
    'OMIM:610019': 'CATARACT 18; CTRCT18',
    'OMIM:610031': 'CORTICAL DYSPLASIA, COMPLEX, WITH OTHER BRAIN MALFORMATIONS 7; CDCBM7',
    'OMIM:610127': 'CEROID LIPOFUSCINOSIS, NEURONAL, 10; CLN10',
    'OMIM:610181': 'AICARDI-GOUTIERES SYNDROME 2; AGS2',
    'OMIM:610188': 'JOUBERT SYNDROME 5; JBTS5',
    'OMIM:610217': 'NEURODEGENERATION WITH BRAIN IRON ACCUMULATION 2B; NBIA2B',
    'OMIM:610329': 'AICARDI-GOUTIERES SYNDROME 3; AGS3',
    'OMIM:610333': 'AICARDI-GOUTIERES SYNDROME 4; AGS4',
    'OMIM:610359': 'RETINITIS PIGMENTOSA 33; RP33',
    'OMIM:610443': 'KOOLEN-DE VRIES SYNDROME; KDVS',
    'OMIM:610444': 'NIGHT BLINDNESS, CONGENITAL STATIONARY, AUTOSOMAL DOMINANT 3; CSNBAD3',
    'OMIM:610489': 'PIGMENTED NODULAR ADRENOCORTICAL DISEASE, PRIMARY, 1; PPNAD1',
    'OMIM:610532': 'LEUKODYSTROPHY, HYPOMYELINATING, 5; HLD5',
    'OMIM:610688': 'JOUBERT SYNDROME 6; JBTS6',
    'OMIM:610725': 'NEPHROTIC SYNDROME, TYPE 3; NPHS3',
    'OMIM:610951': 'CEROID LIPOFUSCINOSIS, NEURONAL, 7; CLN7',
    'OMIM:611091': 'MENTAL RETARDATION, AUTOSOMAL RECESSIVE 5; MRT5',
    'OMIM:611302': 'SPASTIC ATAXIA 2, AUTOSOMAL RECESSIVE; SPAX2',
    'OMIM:611307': 'MUSCULAR DYSTROPHY, LIMB-GIRDLE, AUTOSOMAL RECESSIVE 12; LGMDR12',
    'OMIM:611560': 'JOUBERT SYNDROME 7; JBTS7',
    'OMIM:611603': 'LISSENCEPHALY 3; LIS3',
    'OMIM:611705': 'SALIH MYOPATHY; SALMY',
    'OMIM:611721': 'COMBINED SAPOSIN DEFICIENCY',
    'OMIM:611726': 'EPILEPSY, PROGRESSIVE MYOCLONIC, 3, WITH OR WITHOUT INTRACELLULAR INCLUSIONS; EPM3',
    'OMIM:611755': 'LEBER CONGENITAL AMAUROSIS 10; LCA10',
    'OMIM:612015': 'CONGENITAL DISORDER OF GLYCOSYLATION, TYPE In; CDG1N',
    'OMIM:612095': 'RETINITIS PIGMENTOSA 41; RP41',
    'OMIM:612126': 'GLUT1 DEFICIENCY SYNDROME 2; GLUT1DS2',
    'OMIM:612285': 'JOUBERT SYNDROME 9; JBTS9',
    'OMIM:612337': 'MENTAL RETARDATION, AUTOSOMAL DOMINANT 22; MRD22',
    'OMIM:612370': 'HYPOGONADOTROPIC HYPOGONADISM 5 WITH OR WITHOUT ANOSMIA; HH5',
    'OMIM:612438': 'LEUKODYSTROPHY, HYPOMYELINATING, 6; HLD6',
    'OMIM:612528': 'DIAMOND-BLACKFAN ANEMIA 5; DBA5',
    'OMIM:612621': 'MENTAL RETARDATION, AUTOSOMAL DOMINANT 5; MRD5',
    'OMIM:612712': 'LEBER CONGENITAL AMAUROSIS 13; LCA13',
    'OMIM:612716': 'DYSTONIA, DOPA-RESPONSIVE, DUE TO SEPIAPTERIN REDUCTASE DEFICIENCY',
    'OMIM:612780': 'SEIZURES, SENSORINEURAL DEAFNESS, ATAXIA, MENTAL RETARDATION, AND ELECTROLYTE IMBALANCE; SESAMES',
    'OMIM:612936': 'SPASTIC PARAPLEGIA 50, AUTOSOMAL RECESSIVE; SPG50',
    'OMIM:612943': 'RETINITIS PIGMENTOSA 42; RP42',
    'OMIM:612951': 'LEUKOENCEPHALOPATHY, CYSTIC, WITHOUT MEGALENCEPHALY',
    'OMIM:613065': 'LEUKEMIA, ACUTE LYMPHOBLASTIC; ALL',
    'OMIM:613091': 'SHORT-RIB THORACIC DYSPLASIA 3 WITH OR WITHOUT POLYDACTYLY; SRTD3',
    'OMIM:613155': 'MUSCULAR DYSTROPHY-DYSTROGLYCANOPATHY (CONGENITAL WITH IMPAIRED INTELLECTUAL IMPAIRMENT), TYPE B, 1; MDDGB1',
    'OMIM:613156': 'MUSCULAR DYSTROPHY-DYSTROGLYCANOPATHY (CONGENITAL WITH IMPAIRED INTELLECTUAL DEVELOPMENT), TYPE B, 2; MDDGB2',
    'OMIM:613158': 'MUSCULAR DYSTROPHY-DYSTROGLYCANOPATHY (LIMB-GIRDLE), TYPE C, 2; MDDGC2',
    'OMIM:613192': 'MENTAL RETARDATION, AUTOSOMAL RECESSIVE 13; MRT13',
    'OMIM:613205': 'MUSCULAR DYSTROPHY, CONGENITAL, LMNA-RELATED',
    'OMIM:613216': 'NIGHT BLINDNESS, CONGENITAL STATIONARY, TYPE 1C; CSNB1C',
    'OMIM:613217': 'DIARRHEA 5, WITH TUFTING ENTEROPATHY, CONGENITAL; DIAR5',
    'OMIM:613402': 'MICROCEPHALY, SEIZURES, AND DEVELOPMENTAL DELAY; MCSZ',
    'OMIM:613428': 'RETINITIS PIGMENTOSA 54; RP54',
    'OMIM:613454': 'RETT SYNDROME, CONGENITAL VARIANT',
    'OMIM:613550': 'NEPHRONOPHTHISIS 11; NPHP11',
    'OMIM:613561': 'MYOPATHY, LACTIC ACIDOSIS, AND SIDEROBLASTIC ANEMIA 2; MLASA2',
    'OMIM:613587': 'OCCULT MACULAR DYSTROPHY; OCMD',
    'OMIM:613612': 'CONGENITAL DISORDER OF GLYCOSYLATION, TYPE IIi; CDG2I',
    'OMIM:613660': 'CONE-ROD DYSTROPHY 15; CORD15',
    'OMIM:613668': 'MICROCEPHALY, POSTNATAL PROGRESSIVE, WITH SEIZURES AND BRAIN ATROPHY',
    'OMIM:613680': 'BEAULIEU-BOYCOTT-INNES SYNDROME; BBIS',
    'OMIM:613684': 'RUBINSTEIN-TAYBI SYNDROME 2; RSTS2',
    'OMIM:613690': 'CARDIOMYOPATHY, FAMILIAL HYPERTROPHIC, 7; CMH7',
    'OMIM:613706': 'NOONAN SYNDROME 7; NS7',
    'OMIM:613722': 'DEVELOPMENTAL AND EPILEPTIC ENCEPHALOPATHY 12; DEE12',
    'OMIM:613731': 'RETINITIS PIGMENTOSA 4; RP4',
    'OMIM:613744': 'SPASTIC PARAPLEGIA 51, AUTOSOMAL RECESSIVE; SPG51',
    'OMIM:613750': 'RETINITIS PIGMENTOSA 27; RP27',
    'OMIM:613756': 'RETINITIS PIGMENTOSA 49; RP49',
    'OMIM:613767': 'RETINITIS PIGMENTOSA 45; RP45',
    'OMIM:613794': 'RETINITIS PIGMENTOSA 20; RP20',
    'OMIM:613809': 'RETINITIS PIGMENTOSA 39; RP39',
    'OMIM:613810': 'RETINITIS PIGMENTOSA 43; RP43',
    'OMIM:613811': 'PONTOCEREBELLAR HYPOPLASIA, TYPE 2D; PCH2D',
    'OMIM:613820': 'NEPHRONOPHTHISIS 12; NPHP12',
    'OMIM:613835': 'LEBER CONGENITAL AMAUROSIS 8; LCA8',
    'OMIM:613861': 'RETINITIS PIGMENTOSA 59; RP59',
    'OMIM:613862': 'RETINITIS PIGMENTOSA 38; RP38',
    'OMIM:614034': 'HEME OXYGENASE 1 DEFICIENCY; HMOX1D',
    'OMIM:614065': 'MYOPATHY, DISTAL, 4; MPD4',
    'OMIM:614173': 'JOUBERT SYNDROME 13; JBTS13',
    'OMIM:614180': 'RETINITIS PIGMENTOSA 61; RP61',
    'OMIM:614181': 'RETINITIS PIGMENTOSA 62; RP62',
    'OMIM:614199': 'NEPHROTIC SYNDROME, TYPE 5, WITH OR WITHOUT OCULAR ABNORMALITIES; NPHS5',
    'OMIM:614202': 'RAFIQ SYNDROME; RAFQS',
    'OMIM:614225': 'WARBURG MICRO SYNDROME 2; WARBM2',
    'OMIM:614254': 'NEURODEVELOPMENTAL DISORDER WITH OR WITHOUT HYPERKINETIC MOVEMENTS AND SEIZURES, AUTOSOMAL DOMINANT; NDHMSD',
    'OMIM:614255': 'NESCAV SYNDROME; NESCAVS',
    'OMIM:614299': 'MULTIPLE MITOCHONDRIAL DYSFUNCTIONS SYNDROME 2 WITH HYPERGLYCINEMIA; MMDS2',
    'OMIM:614381': 'LEUKODYSTROPHY, HYPOMYELINATING, 8, WITH OR WITHOUT OLIGODONTIA AND/OR HYPOGONADOTROPIC HYPOGONADISM; HLD8',
    'OMIM:614424': 'JOUBERT SYNDROME 14; JBTS14',
    'OMIM:614500': 'CONE-ROD DYSTROPHY 16; CORD16',
    'OMIM:614557': 'EHLERS-DANLOS SYNDROME, KYPHOSCOLIOTIC TYPE, 2; EDSKSCL2',
    'OMIM:614607': 'COFFIN-SIRIS SYNDROME 2; CSS2',
    'OMIM:614615': 'JOUBERT SYNDROME 17; JBTS17',
    'OMIM:614669': 'AURICULOCONDYLAR SYNDROME 2; ARCND2',
    'OMIM:614678': 'PONTOCEREBELLAR HYPOPLASIA, TYPE 1B; PCH1B',
    'OMIM:614744': 'FACIAL PARESIS, HEREDITARY CONGENITAL, 3; HCFP3',
    'OMIM:614753': 'SOTOS SYNDROME 2; SOTOS2',
    'OMIM:614831': 'SPINOCEREBELLAR ATAXIA, AUTOSOMAL RECESSIVE 13; SCAR13',
    'OMIM:614833': 'MICROCEPHALY, SHORT STATURE, AND POLYMICROGYRIA WITH OR WITHOUT SEIZURES; MSSP',
    'OMIM:614876': 'PEROXISOME BIOGENESIS DISORDER 8A (ZELLWEGER); PBD8A',
    'OMIM:614877': 'PEROXISOME BIOGENESIS DISORDER 8B; PBD8B',
    'OMIM:614932': 'COMBINED OXIDATIVE PHOSPHORYLATION DEFICIENCY 13; COXPD13',
    'OMIM:614945': 'DEAFNESS, AUTOSOMAL RECESSIVE 18B; DFNB18B',
    'OMIM:615030': 'SPASTIC PARAPLEGIA 56, AUTOSOMAL RECESSIVE; SPG56',
    'OMIM:615031': 'SPASTIC PARAPLEGIA 49, AUTOSOMAL RECESSIVE; SPG49',
    'OMIM:615065': 'ARTHROGRYPOSIS, DISTAL, TYPE 5D; DA5D',
    'OMIM:615071': 'ALAZAMI SYNDROME; ALAZS',
    'OMIM:615095': 'MICROCEPHALY 10, PRIMARY, AUTOSOMAL RECESSIVE; MCPH10',
    'OMIM:615181': 'MUSCULAR DYSTROPHY-DYSTROGLYCANOPATHY (CONGENITAL WITH BRAIN AND EYE ANOMALIES), TYPE A, 11; MDDGA11',
    'OMIM:615190': 'DYSKERATOSIS CONGENITA, AUTOSOMAL RECESSIVE 5; DKCB5',
    'OMIM:615191': 'LISSENCEPHALY 5; LIS5',
    'OMIM:615268': 'CEREBELLAR ATAXIA, MENTAL RETARDATION, AND DYSEQUILIBRIUM SYNDROME 4; CAMRQ4',
    'OMIM:615286': 'MENTAL RETARDATION, AUTOSOMAL RECESSIVE 36; MRT36',
    'OMIM:615352': 'MUSCULAR DYSTROPHY-DYSTROGLYCANOPATHY (LIMB-GIRDLE), TYPE C, 14; MDDGC14',
    'OMIM:615411': 'CORTICAL DYSPLASIA, COMPLEX, WITH OTHER BRAIN MALFORMATIONS 3; CDCBM3',
    'OMIM:615412': 'CORTICAL DYSPLASIA, COMPLEX, WITH OTHER BRAIN MALFORMATIONS 4; CDCBM4',
    'OMIM:615419': 'HYPOTONIA, INFANTILE, WITH PSYCHOMOTOR RETARDATION AND CHARACTERISTIC FACIES 1; IHPRF1',
    'OMIM:615471': 'MITOCHONDRIAL DNA DEPLETION SYNDROME 13 (ENCEPHALOMYOPATHIC TYPE); MTDPS13',
    'OMIM:615476': 'DEVELOPMENTAL AND EPILEPTIC ENCEPHALOPATHY 18; DEE18',
    'OMIM:615485': 'BAINBRIDGE-ROPERS SYNDROME; BRPS',
    'OMIM:615502': 'MENTAL RETARDATION, AUTOSOMAL DOMINANT 21; MRD21',
    'OMIM:615546': 'VAN MALDERGEM SYNDROME 2; VMLDS2',
    'OMIM:615574': 'ASPARAGINE SYNTHETASE DEFICIENCY; ASNSD',
    'OMIM:615681': 'SPASTIC PARAPLEGIA 62, AUTOSOMAL RECESSIVE; SPG62',
    'OMIM:615715': 'BONE MARROW FAILURE SYNDROME 2; BMFS2',
    'OMIM:615716': 'HYPERPHOSPHATASIA WITH MENTAL RETARDATION SYNDROME 4; HPMRS4',
    'OMIM:615760': 'MICROCEPHALY, PROGRESSIVE, WITH SEIZURES AND CEREBRAL AND CEREBELLAR ATROPHY; MSCCA',
    'OMIM:615763': 'CORTICAL DYSPLASIA, COMPLEX, WITH OTHER BRAIN MALFORMATIONS 5; CDCBM5',
    'OMIM:615809': 'PONTOCEREBELLAR HYPOPLASIA, TYPE 9; PCH9',
    'OMIM:615829': 'XIA-GIBBS SYNDROME; XIGIS',
    'OMIM:615834': 'MENTAL RETARDATION, AUTOSOMAL DOMINANT 26; MRD26',
    'OMIM:615846': 'AICARDI-GOUTIERES SYNDROME 7; AGS7',
    'OMIM:615866': 'COFFIN-SIRIS SYNDROME 9; CSS9',
    'OMIM:615909': 'DIAMOND-BLACKFAN ANEMIA 13; DBA13',
    'OMIM:615948': 'OROFACIODIGITAL SYNDROME XIV; OFD14',
    'OMIM:615959': 'MYOPATHY, CENTRONUCLEAR, 5; CNM5',
    'OMIM:615960': 'PORETTI-BOLTSHAUSER SYNDROME; PTBHS',
    'OMIM:615973': 'CONE-ROD DYSTROPHY 20; CORD20',
    'OMIM:615981': 'BARDET-BIEDL SYNDROME 2; BBS2',
    'OMIM:615982': 'BARDET-BIEDL SYNDROME 4; BBS4',
    'OMIM:615983': 'BARDET-BIEDL SYNDROME 5; BBS5',
    'OMIM:615993': 'BARDET-BIEDL SYNDROME 16; BBS16',
    'OMIM:616051': 'MICROCEPHALY 13, PRIMARY, AUTOSOMAL RECESSIVE; MCPH13',
    'OMIM:616056': 'DEVELOPMENTAL AND EPILEPTIC ENCEPHALOPATHY 26; DEE26',
    'OMIM:616081': 'PONTOCEREBELLAR HYPOPLASIA, TYPE 1C; PCH1C',
    'OMIM:616094': 'MUSCULAR DYSTROPHY-DYSTROGLYCANOPATHY (LIMB-GIRDLE), TYPE C, 12; MDDGC12',
    'OMIM:616127': 'SPINOCEREBELLAR ATAXIA, AUTOSOMAL RECESSIVE 17; SCAR17',
    'OMIM:616140': 'LEUKODYSTROPHY, HYPOMYELINATING, 9; HLD9',
    'OMIM:616155': 'CHARCOT-MARIE-TOOTH DISEASE, AXONAL, TYPE 2S; CMT2S',
    'OMIM:616171': 'MICROCEPHALY AND CHORIORETINOPATHY, AUTOSOMAL RECESSIVE, 2; MCCRP2',
    'OMIM:616199': 'POLYGLUCOSAN BODY MYOPATHY 2; PGBM2',
    'OMIM:616211': 'DEVELOPMENTAL AND EPILEPTIC ENCEPHALOPATHY 28; DEE28',
    'OMIM:616263': 'NEUROLOGIC, ENDOCRINE, AND PANCREATIC DISEASE, MULTISYSTEM, INFANTILE-ONSET; IMNEPD',
    'OMIM:616266': 'CONGENITAL CONTRACTURES OF THE LIMBS AND FACE, HYPOTONIA, AND DEVELOPMENTAL DELAY; CLIFAHDD',
    'OMIM:616271': '3-METHYLGLUTACONIC ACIDURIA, TYPE VII; MGCA7',
    'OMIM:616277': 'MITOCHONDRIAL SHORT-CHAIN ENOYL-CoA HYDRATASE 1 DEFICIENCY; ECHS1D',
    'OMIM:616281': 'NEURODEVELOPMENTAL DISORDER WITH SPASTIC PARAPLEGIA AND MICROCEPHALY; NEDSPM',
    'OMIM:616321': 'MYASTHENIC SYNDROME, CONGENITAL, 3A, SLOW-CHANNEL; CMS3A',
    'OMIM:616354': 'SPINOCEREBELLAR ATAXIA, AUTOSOMAL RECESSIVE 20; SCAR20',
    'OMIM:616394': 'RETINITIS PIGMENTOSA 71; RP71',
    'OMIM:616420': 'LEUKODYSTROPHY, HYPOMYELINATING, 10; HLD10',
    'OMIM:616421': 'MYOCLONIC-ATONIC EPILEPSY; MAE',
    'OMIM:616471': 'BETHLEM MYOPATHY 2; BTHLM2',
    'OMIM:616490': 'JOUBERT SYNDROME 23; JBTS23',
    'OMIM:616531': 'POLYMICROGYRIA, PERISYLVIAN, WITH CEREBELLAR HYPOPLASIA AND ARTHROGRYPOSIS; PMGYCHA',
    'OMIM:616544': 'RETINITIS PIGMENTOSA 73; RP73',
    'OMIM:616562': 'RETINITIS PIGMENTOSA 74; RP74',
    'OMIM:616564': 'NOONAN SYNDROME 10; NS10',
    'OMIM:616632': 'SEIZURES, CORTICAL BLINDNESS, AND MICROCEPHALY SYNDROME; SCBMS',
    'OMIM:616647': 'DEVELOPMENTAL AND EPILEPTIC ENCEPHALOPATHY 35; DEE35',
    'OMIM:616649': 'SPHEROCYTOSIS, TYPE 2; SPH2',
    'OMIM:616651': 'ROIFMAN SYNDROME; RFMN',
    'OMIM:616654': 'JOUBERT SYNDROME 24; JBTS24',
    'OMIM:616657': 'SPASTIC TETRAPLEGIA, THIN CORPUS CALLOSUM, AND PROGRESSIVE MICROCEPHALY; SPATCCM',
    'OMIM:616668': 'CHARCOT-MARIE-TOOTH DISEASE, AXONAL, TYPE 2X; CMT2X',
    'OMIM:616683': 'LEUKODYSTROPHY, HYPOMYELINATING, 12; HLD12',
    'OMIM:616721': 'CONGENITAL DISORDER OF GLYCOSYLATION, TYPE IIn; CDG2N',
    'OMIM:616732': 'OPTIC ATROPHY 10 WITH OR WITHOUT ATAXIA, MENTAL RETARDATION, AND SEIZURES; OPA10',
    'OMIM:616738': 'RADIOULNAR SYNOSTOSIS WITH AMEGAKARYOCYTIC THROMBOCYTOPENIA 2; RUSAT2',
    'OMIM:616740': 'IMMUNODEFICIENCY 46; IMD46',
    'OMIM:616789': 'MENTAL RETARDATION AND DISTINCTIVE FACIAL FEATURES WITH OR WITHOUT CARDIAC DEFECTS; MRFACD',
    'OMIM:616801': 'HYPOTONIA, INFANTILE, WITH PSYCHOMOTOR RETARDATION AND CHARACTERISTIC FACIES 2; IHPRF2',
    'OMIM:616875': 'CEREBELLAR ATROPHY, VISUAL IMPAIRMENT, AND PSYCHOMOTOR RETARDATION; CAVIPMR',
    'OMIM:616892': 'NEPHROTIC SYNDROME, TYPE 12; NPHS12',
    'OMIM:616900': 'HYPOTONIA, INFANTILE, WITH PSYCHOMOTOR RETARDATION AND CHARACTERISTIC FACIES 3; IHPRF3',
    'OMIM:616973': 'MENTAL RETARDATION, AUTOSOMAL DOMINANT 42; MRD42',
    'OMIM:617011': 'MACROCEPHALY, DYSMORPHIC FACIES, AND PSYCHOMOTOR RETARDATION; MDFPMR',
    'OMIM:617013': 'HYPERMANGANESEMIA WITH DYSTONIA 2; HMNDYT2',
    'OMIM:617047': 'CARDIOMYOPATHY, FAMILIAL HYPERTROPHIC, 26; CMH26',
    'OMIM:617052': 'BONE MARROW FAILURE SYNDROME 3; BMFS3',
    'OMIM:617053': 'MIRAGE SYNDROME; MIRAGE',
    'OMIM:617093': 'GROWTH RETARDATION, IMPAIRED INTELLECTUAL DEVELOPMENT, HYPOTONIA, AND HEPATOPATHY; GRIDHH',
    'OMIM:617106': 'DEVELOPMENTAL AND EPILEPTIC ENCEPHALOPATHY 42; DEE42',
    'OMIM:617120': 'JOUBERT SYNDROME 27; JBTS27',
    'OMIM:617121': 'JOUBERT SYNDROME 28; JBTS28',
    'OMIM:617123': 'RETINITIS PIGMENTOSA 76; RP76',
    'OMIM:617137': 'FRONTOMETAPHYSEAL DYSPLASIA 2; FMD2',
    'OMIM:617146': 'ARTHROGRYPOSIS, DISTAL, WITH IMPAIRED PROPRIOCEPTION AND TOUCH; DAIPT',
    'OMIM:617183': 'HAREL-YOON SYNDROME; HAYOS',
    'OMIM:617193': 'ENCEPHALOPATHY, PROGRESSIVE, EARLY-ONSET, WITH BRAIN ATROPHY AND THIN CORPUS CALLOSUM; PEBAT',
    'OMIM:617222': 'SUDDEN CARDIAC FAILURE, INFANTILE; SCFI',
    'OMIM:617276': 'DEVELOPMENTAL AND EPILEPTIC ENCEPHALOPATHY 48; DEE48',
    'OMIM:617330': 'HYPOTONIA, ATAXIA, AND DELAYED DEVELOPMENT SYNDROME; HADDS',
    'OMIM:617350': 'DEVELOPMENTAL AND EPILEPTIC ENCEPHALOPATHY 52; DEE52',
    'OMIM:617397': 'PSEUDO-TORCH SYNDROME 2; PTORCH2',
    'OMIM:617433': 'RETINITIS PIGMENTOSA 78; RP78',
    'OMIM:617443': 'BLEEDING DISORDER, PLATELET-TYPE, 21; BDPLT21',
    'OMIM:617460': 'RETINITIS PIGMENTOSA 79; RP79',
    'OMIM:617481': 'NEURODEVELOPMENTAL DISORDER WITH MICROCEPHALY, HYPOTONIA, AND VARIABLE BRAIN ANOMALIES; NMIHBA',
    'OMIM:617537': 'RAHMAN SYNDROME; RMNS',
    'OMIM:617547': 'RETINAL DYSTROPHY WITH OR WITHOUT MACULAR STAPHYLOMA; RDMS',
    'OMIM:617622': 'JOUBERT SYNDROME 30; JBTS30',
    'OMIM:617675': 'MYOPATHY, MITOCHONDRIAL, AND ATAXIA; MMYAT',
    'OMIM:617681': 'BLEPHAROCHEILODONTIC SYNDROME 2; BCDS2',
    'OMIM:617694': 'AL KAISSI SYNDROME; ALKAS',
    'OMIM:617781': 'RETINITIS PIGMENTOSA 80; RP80',
    'OMIM:617805': 'RENAL HYPODYSPLASIA/APLASIA 3; RHDA3',
    'OMIM:617807': 'NEURODEVELOPMENTAL DISORDER WITH ATAXIC GAIT, ABSENT SPEECH, AND DECREASED CORTICAL WHITE MATTER; NDAGSCW',
    'OMIM:617829': 'EPILEPTIC ENCEPHALOPATHY, INFANTILE OR EARLY CHILDHOOD, 2; IECEE2',
    'OMIM:617873': 'COMBINED OXIDATIVE PHOSPHORYLATION DEFICIENCY 35; COXPD35',
    'OMIM:617948': 'ELLIPTOCYTOSIS 3; EL3',
    'OMIM:617954': 'MULTIPLE MITOCHONDRIAL DYSFUNCTIONS SYNDROME 6; MMDS6',
    'OMIM:618056': 'NEURODEVELOPMENTAL DISORDER WITH CEREBELLAR ATROPHY AND WITH OR WITHOUT SEIZURES; NEDCAS',
    'OMIM:618088': 'NEURODEVELOPMENTAL DISORDER WITH REGRESSION, ABNORMAL MOVEMENTS, LOSS OF SPEECH, AND SEIZURES; NEDAMSS',
    'OMIM:618129': 'MUSCULAR DYSTROPHY, LIMB-GIRDLE, AUTOSOMAL DOMINANT 4; LGMDD4',
    'OMIM:618138': 'MUSCULAR DYSTROPHY, LIMB-GIRDLE, AUTOSOMAL RECESSIVE 23; LGMDR23',
    'OMIM:618174': 'CORTICAL DYSPLASIA, COMPLEX, WITH OTHER BRAIN MALFORMATIONS 9; CDCBM9',
    'OMIM:618225': 'MITOCHONDRIAL COMPLEX I DEFICIENCY, NUCLEAR TYPE 4; MC1DN4',
    'OMIM:618273': 'MEGA-CORPUS-CALLOSUM SYNDROME WITH CEREBELLAR HYPOPLASIA AND CORTICAL MALFORMATIONS; MCCCHCM',
    'OMIM:618316': 'INTELLECTUAL DEVELOPMENTAL DISORDER WITH CARDIAC DEFECTS AND DYSMORPHIC FACIES; IDDCDF',
    'OMIM:618325': 'LISSENCEPHALY 9 WITH COMPLEX BRAINSTEM MALFORMATION; LIS9',
    'OMIM:618404': 'LEUKODYSTROPHY, HYPOMYELINATING, 18; HLD18',
    'OMIM:618512': "O'DONNELL-LURIA-RODAN SYNDROME; ODLURO",
    '190400': 'TRIGEMINAL NEURALGIA',
    '207790': 'ARACHNOID CYSTS, INTRACRANIAL',
    'OMIM:100100': 'DIABETES INSIPIDUS, NEPHROGENIC, 2, AUTOSOMAL; NDI2',
    'OMIM:100300': 'ADAMS-OLIVER SYNDROME 1; AOS1',
    'OMIM:100800': 'ACHONDROPLASIA; ACH',
    'OMIM:101120': 'ACROCEPHALOPOLYSYNDACTYLY TYPE III',
    'OMIM:102200': 'PITUITARY ADENOMA 1, MULTIPLE TYPES; PITA1',
    'OMIM:102500': 'HAJDU-CHENEY SYNDROME; HJCYS',
    'OMIM:105830': 'ANGELMAN SYNDROME; AS',
    'OMIM:107480': 'TOWNES-BROCKS SYNDROME 1; TBS1',
    'OMIM:107970': 'ARRHYTHMOGENIC RIGHT VENTRICULAR DYSPLASIA, FAMILIAL, 1; ARVD1',
    'OMIM:108145': 'ARTHROGRYPOSIS, DISTAL, TYPE 5; DA5',
    'OMIM:109730': 'AORTIC VALVE DISEASE 1; AOVD1',
    'OMIM:117550': 'SOTOS SYNDROME 1; SOTOS1',
    'OMIM:122430': 'CORNEAL HYPESTHESIA WITH RETINAL ABNORMALITIES, SENSORINEURAL DEAFNESS, UNUSUAL FACIES, PERSISTENT DUCTUS ARTERIOSUS, AND MENTAL RETARDATION',
    'OMIM:125800': 'DIABETES INSIPIDUS, NEPHROGENIC, 2, AUTOSOMAL; NDI2',
    'OMIM:130000': 'EHLERS-DANLOS SYNDROME, CLASSIC TYPE, 1; EDSCL1',
    'OMIM:130020': 'EHLERS-DANLOS SYNDROME, HYPERMOBILITY TYPE; EDSHMB',
    'OMIM:132900': 'AORTIC ANEURYSM, FAMILIAL THORACIC 4; AAT4',
    'OMIM:133180': 'ERYTHROLEUKEMIA, FAMILIAL, SUSCEPTIBILITY TO; FERLK',
    'OMIM:133701': 'EXOSTOSES, MULTIPLE, TYPE II; EXT2',
    'OMIM:135150': 'BIRT-HOGG-DUBE SYNDROME; BHD',
    'OMIM:137580': 'GILLES DE LA TOURETTE SYNDROME; GTS',
    'OMIM:142690': 'ACNE INVERSA, FAMILIAL, 1; ACNINV1',
    'OMIM:143860': 'HYPERCHLORHIDROSIS, ISOLATED; HYCHL',
    'OMIM:146450': 'HYPOSPADIAS 3, AUTOSOMAL; HYSP3',
    'OMIM:151900': 'LIPOMATOSIS, MULTIPLE',
    'OMIM:157700': 'MITRAL VALVE PROLAPSE 1; MVP1',
    'OMIM:157980': 'MOMO SYNDROME',
    'OMIM:162091': 'SCHWANNOMATOSIS 1; SWNTS1',
    'OMIM:164210': 'HEMIFACIAL MICROSOMIA; HFM',
    'OMIM:164230': 'OBSESSIVE-COMPULSIVE DISORDER; OCD',
    'OMIM:176450': 'CURRARINO SYNDROME',
    'OMIM:181700': 'SCLEROCORNEA, AUTOSOMAL DOMINANT',
    'OMIM:182212': 'SHPRINTZEN-GOLDBERG CRANIOSYNOSTOSIS SYNDROME; SGS',
    'OMIM:184255': 'SPONDYLOMETAPHYSEAL DYSPLASIA, CORNER FRACTURE TYPE; SMDCF',
    'OMIM:184900': 'STIFF SKIN SYNDROME; SSKS',
    'OMIM:185480': 'SUPRABULBAR PARESIS, CONGENITAL',
    'OMIM:186300': 'SYNDACTYLY, TYPE V; SDTY5',
    'OMIM:190400': 'TRIGEMINAL NEURALGIA',
    'OMIM:191830': 'RENAL HYPODYSPLASIA/APLASIA 1; RHDA1',
    'OMIM:192350': 'VATER/VACTERL ASSOCIATION',
    'OMIM:192430': 'VELOCARDIOFACIAL SYNDROME; VCFS',
    'OMIM:192600': 'CARDIOMYOPATHY, FAMILIAL HYPERTROPHIC, 1; CMH1',
    'OMIM:207790': 'ARACHNOID CYSTS, INTRACRANIAL',
    'OMIM:207950': 'CHIARI MALFORMATION TYPE II',
    'OMIM:208085': 'ARTHROGRYPOSIS, RENAL DYSFUNCTION, AND CHOLESTASIS 1; ARCS1',
    'OMIM:208230': 'PROGRESSIVE PSEUDORHEUMATOID DYSPLASIA; PPRD',
    'OMIM:210600': 'SECKEL SYNDROME 1; SCKL1',
    'OMIM:211400': 'BRONCHIECTASIS WITH OR WITHOUT ELEVATED SWEAT CHLORIDE 1; BESC1',
    'OMIM:215140': 'GREENBERG DYSPLASIA; GRBGD',
    'OMIM:216340': 'YUNIS-VARON SYNDROME; YVS',
    'OMIM:219150': 'CUTIS LAXA, AUTOSOMAL RECESSIVE, TYPE IIIA; ARCL3A',
    'OMIM:223370': 'DUBOWITZ SYNDROME',
    'OMIM:226750': 'KOHLSCHUTTER-TONZ SYNDROME; KTZS',
    'OMIM:228200': 'FEMUR-FIBULA-ULNA SYNDROME',
    'OMIM:242300': 'ICHTHYOSIS, CONGENITAL, AUTOSOMAL RECESSIVE 1; ARCI1',
    'OMIM:244300': 'KAPUR-TORIELLO SYNDROME',
    'OMIM:255995': 'MYOPATHY, CONGENITAL, BAILEY-BLOCH; MYPBB',
    'OMIM:256520': 'NEU-LAXOVA SYNDROME 1; NLS1',
    'OMIM:266600': 'INFLAMMATORY BOWEL DISEASE (CROHN DISEASE) 1; IBD1',
    'OMIM:269200': 'AUTOIMMUNE POLYENDOCRINE SYNDROME, TYPE II; APS2',
    'OMIM:276950': 'VACTERL ASSOCIATION WITH HYDROCEPHALUS',
    'OMIM:300816': 'COMBINED OXIDATIVE PHOSPHORYLATION DEFICIENCY 6; COXPD6',
    'OMIM:300953': 'TRICHOTHIODYSTROPHY 5, NONPHOTOSENSITIVE; TTD5',
    'OMIM:305000': 'DYSKERATOSIS CONGENITA, X-LINKED; DKCX',
    'OMIM:312750': 'RETT SYNDROME; RTT',
    'OMIM:600920': 'VAN DEN ENDE-GUPTA SYNDROME; VDEGS',
    'OMIM:601144': 'BRUGADA SYNDROME 1; BRGDA1',
    'OMIM:601853': 'GOMEZ-LOPEZ-HERNANDEZ SYNDROME; GLHS',
    'OMIM:602066': 'CONVULSIONS, FAMILIAL INFANTILE, WITH PAROXYSMAL CHOREOATHETOSIS; ICCA',
    'OMIM:602535': 'MARSHALL-SMITH SYNDROME; MRSHSS',
    'OMIM:603438': 'RADIOULNAR SYNOSTOSIS WITH MICROCEPHALY, SHORT STATURE, SCOLIOSIS, AND MENTAL RETARDATION',
    'OMIM:604715': 'ORTHOSTATIC INTOLERANCE',
    'OMIM:606003': 'TRANSALDOLASE DEFICIENCY; TALDOD',
    'OMIM:606519': 'PHACE ASSOCIATION',
    'OMIM:607086': 'AORTIC ANEURYSM, FAMILIAL THORACIC 1; AAT1',
    'OMIM:607834': 'ANXIETY',
    'OMIM:608389': 'BRANCHIOOTIC SYNDROME 3; BOS3',
    'OMIM:608940': 'SPONDYLOMETAPHYSEAL DYSPLASIA WITH CONE-ROD DYSTROPHY; SMDCRD',
    'OMIM:609192': 'LOEYS-DIETZ SYNDROME 1; LDS1',
    'OMIM:609528': 'CEREBRAL DYSGENESIS, NEUROPATHY, ICHTHYOSIS, AND PALMOPLANTAR KERATODERMA SYNDROME',
    'OMIM:612863': 'CHROMOSOME 6q24-q25 DELETION SYNDROME',
    'OMIM:613075': 'MACS SYNDROME',
    'OMIM:613172': 'CARDIOMYOPATHY, DILATED, 1DD; CMD1DD',
    'OMIM:613229': 'TRICHOTILLOMANIA; TTM',
    'OMIM:613982': 'OSTEOGENESIS IMPERFECTA, TYPE VI; OI6',
    'OMIM:614219': 'ADAMS-OLIVER SYNDROME 2; AOS2',
    'OMIM:614416': 'RADIOHUMERAL FUSIONS WITH OTHER SKELETAL AND CRANIOFACIAL ANOMALIES; RHFCA',
    'OMIM:614561': 'LEUKOENCEPHALOPATHY, BRAIN CALCIFICATIONS, AND CYSTS; LCC',
    'OMIM:614575': 'CEREBELLAR ATAXIA, NEUROPATHY, AND VESTIBULAR AREFLEXIA SYNDROME; CANVAS',
    'OMIM:614816': 'LOEYS-DIETZ SYNDROME 4; LDS4',
    'OMIM:614921': 'CONGENITAL DISORDER OF GLYCOSYLATION, TYPE It; CDG1T',
    'OMIM:615145': 'MICROPHTHALMIA, ISOLATED, WITH COLOBOMA 9; MCOPCB9',
    'OMIM:615510': 'ALACRIMA, ACHALASIA, AND MENTAL RETARDATION SYNDROME; AAMR',
    'OMIM:615670': 'SCHWANNOMATOSIS 2; SWNTS2',
    'OMIM:615688': 'VASCULITIS, AUTOINFLAMMATION, IMMUNODEFICIENCY, AND HEMATOLOGIC DEFECTS SYNDROME; VAIHS',
    'OMIM:615877': 'MICROPHTHALMIA/COLOBOMA AND SKELETAL DYSPLASIA SYNDROME; MCSKS',
    'OMIM:615905': 'DEVELOPMENTAL AND EPILEPTIC ENCEPHALOPATHY 25, WITH AMELOGENESIS IMPERFECTA; DEE25',
    'OMIM:616100': 'AUTOIMMUNE LYMPHOPROLIFERATIVE SYNDROME, TYPE V; ALPS5',
    'OMIM:616220': 'FOCAL SEGMENTAL GLOMERULOSCLEROSIS 9; FSGS9',
    'OMIM:616390': 'TRICHOTHIODYSTROPHY 2, PHOTOSENSITIVE; TTD2',
    'OMIM:616576': 'IMMUNODEFICIENCY, COMMON VARIABLE, 12, WITH AUTOIMMUNITY; CVID12',
    'OMIM:616577': 'EPILEPSY, HEARING LOSS, AND MENTAL RETARDATION SYNDROME; EHLMRS',
    'OMIM:616580': 'AU-KLINE SYNDROME; AUKS',
    'OMIM:616723': 'SPONDYLOEPIMETAPHYSEAL DYSPLASIA, FADEN-ALKURAYA TYPE; SEMDFA',
    'OMIM:616878': 'METABOLIC CRISES, RECURRENT, WITH RHABDOMYOLYSIS, CARDIAC ARRHYTHMIAS, AND NEURODEGENERATION; MECRCN',
    'OMIM:616954': 'YOU-HOOVER-FONG SYNDROME; YHFS',
    'OMIM:PS123100': 'CRANIOSYNOSTOSIS 1; CRS1',
    'OMIM:PS252350': 'MOYAMOYA DISEASE 1; MYMY1',
    'OMIM:PS256100': 'NEPHRONOPHTHISIS 2; NPHP2',
    'OMIM:PS256300': 'NEPHROTIC SYNDROME, TYPE 2; NPHS2',
    'OMIM:PS258150': 'SPERMATOGENIC FAILURE 1; SPGF1',
    'OMIM:PS174050': 'POLYCYSTIC LIVER DISEASE 1 WITH OR WITHOUT KIDNEY CYSTS; PCLD1',
    'OMIM:PS173900': 'POLYCYSTIC KIDNEY DISEASE 1 WITH OR WITHOUT POLYCYSTIC LIVER DISEASE; PKD1',
    'OMIM:PS308230': 'IMMUNODEFICIENCY WITH HYPER-IgM, TYPE 3; HIGM3',
    'OMIM:PS610805': 'CONGENITAL ANOMALIES OF KIDNEY AND URINARY TRACT 2; CAKUT2',
    'OMIM:235400': 'HEMOLYTIC UREMIC SYNDROME, ATYPICAL, SUSCEPTIBILITY TO, 1; AHUS1',
    'OMIM:105650': 'DIAMOND-BLACKFAN ANEMIA 1; DBA1',
    'OMIM:126600': 'DOYNE HONEYCOMB RETINAL DYSTROPHY; DHRD',
    'OMIM:133700': 'EXOSTOSES, MULTIPLE, TYPE I; EXT1',
    'OMIM:134200': 'FACIAL PALSY, FAMILIAL RECURRENT PERIPHERAL',
    'OMIM:136550': 'MACULAR DYSTROPHY, RETINAL, 1, NORTH CAROLINA TYPE; MCDR1',
    'OMIM:142340': 'DIAPHRAGMATIC HERNIA, CONGENITAL',
    'OMIM:154780': 'MARSHALL SYNDROME; MRSHS',
    'OMIM:166000': 'ENCHONDROMATOSIS, MULTIPLE, OLLIER TYPE',
    'OMIM:168600': 'PARKINSON DISEASE, LATE-ONSET; PD',
    'OMIM:172870': 'PIGMENTED PARAVENOUS CHORIORETINAL ATROPHY; PPCRA',
    'OMIM:177850': 'PSEUDOXANTHOMA ELASTICUM, FORME FRUSTE',
    'OMIM:180000': 'RETINAL ARTERIES, TORTUOSITY OF; RATOR',
    'OMIM:217990': 'CORPUS CALLOSUM, AGENESIS OF',
    'OMIM:231300': 'GLAUCOMA 3, PRIMARY CONGENITAL, A; GLC3A',
    'OMIM:252350': 'MOYAMOYA DISEASE 1; MYMY1',
    'OMIM:271510': 'SPONDYLOEPIMETAPHYSEAL DYSPLASIA, SPONASTRIME TYPE; SEMDSP',
    'OMIM:277590': 'WEAVER SYNDROME; WVS',
    'OMIM:300049': 'PERIVENTRICULAR NODULAR HETEROTOPIA 1; PVNH1',
    'OMIM:312700': 'RETINOSCHISIS 1, X-LINKED, JUVENILE; RS1',
    'OMIM:600776': 'FRYNS MICROPHTHALMIA SYNDROME',
    'OMIM:600852': 'RETINITIS PIGMENTOSA 17; RP17',
    'OMIM:600977': 'CONE-ROD DYSTROPHY 5; CORD5',
    'OMIM:601813': 'EXUDATIVE VITREORETINOPATHY 4; EVR4',
    'OMIM:603075': 'MACULAR DEGENERATION, AGE-RELATED, 1; ARMD1',
    'OMIM:605361': 'SPINOCEREBELLAR ATAXIA 14; SCA14',
    'OMIM:606157': 'PANTOTHENATE KINASE 2; PANK2',
    'OMIM:608600': 'LIPODYSTROPHY, FAMILIAL PARTIAL, TYPE 1; FPLD1',
    'OMIM:610246': 'SPINOCEREBELLAR ATAXIA 28; SCA28',
    'OMIM:612199': 'CEREBRORETINAL MICROANGIOPATHY WITH CALCIFICATIONS AND CYSTS 1; CRMCC1',
    'OMIM:612280': 'FUCOSIDASE, ALPHA-L, 1; FUCA1',
    'OMIM:614569': 'MULTIPLE ENCHONDROMATOSIS, MAFFUCCI TYPE',
    'OMIM:614844': 'NEPHRONOPHTHISIS 14; NPHP14',
    'OMIM:614875': 'METAPHYSEAL ENCHONDROMATOSIS WITH D-2-HYDROXYGLUTARIC ACIDURIA',
    'OMIM:615032': 'AUTISM, SUSCEPTIBILITY TO, 18; AUTS18',
    'OMIM:615369': 'DEVELOPMENTAL AND EPILEPTIC ENCEPHALOPATHY 94; DEE94',
    'OMIM:616079': 'RETINAL DYSTROPHY WITH INNER RETINAL DYSFUNCTION AND GANGLION CELL ABNORMALITIES; RDGCA',
    'OMIM:618173': 'RETINITIS PIGMENTOSA 83; RP83',
    'OMIM:618613': 'RETINITIS PIGMENTOSA 86; RP86',
    'OMIM:618826': 'RETINITIS PIGMENTOSA 88; RP88',
    'ORPHA:71211': 'Neuromyelitis optica spectrum disorder'
}

# useful links:
#  https://docs.airr-community.org/en/latest/_sources/ontovoc/introduction_ontovoc.rst.txt
#  https://github.com/monarch-initiative/omim/blob/main/data/dipper/curie_map.yaml

disease_system = {
    "DOID": "http://purl.obolibrary.org/obo/DOID_",
    "HP": "http://purl.obolibrary.org/obo/HP_",
    "OMIM": "http://omim.org/entry/",
    "ORPHA": "http://www.orpha.net/ORDO/Orphanet_",
    "NCIT": "http://purl.obolibrary.org/obo/NCIT_",
    "UMLS": "http://linkedlifedata.com/resource/umls/id/",
    "MESH": "http://identifiers.org/mesh/"
}

#
# utilities to populate lookups
#

def omim_title(mimNumber):
    """Retrieve preferredTitle for OMIM."""
    mimNumber = mimNumber.split(':')[-1]
    headers = {
        "Accept": "application/json",
        "ApiKey": os.environ["OMIM_API_KEY"],
    }
    if mimNumber.startswith('PS'):
        response = requests.get(f"https://api.omim.org/api/entry/search?search=phenotypic_series_number:{mimNumber}", headers=headers)
        omim = response.json()
        assert 'omim' in omim, f"Response does not have 'omim' key. {omim}"
        assert 'searchResponse' in omim['omim'], f"Response does not have 'omim.searchResponse' key. {omim}"
        assert omim['omim']['searchResponse']['totalResults'] > 0, f"Response totalResults was 0. {omim}"
        assert 'entryList' in omim['omim']['searchResponse'], f"Response does not have 'omim.searchResponse.entryList' key. {omim}"
        entry = omim['omim']['searchResponse']['entryList'][0]['entry']
        assert 'titles' in entry, f"Response does not have 'omim.searchResponse.entryList[].titles' key. {omim}"
        assert 'preferredTitle' in entry['titles'], f"Response does not have 'omim.searchResponse.entryList[].titles.preferredTitle' key. {omim}"
        return entry['titles']['preferredTitle']
    else:
        response = requests.get(f"https://api.omim.org/api/entry?mimNumber={mimNumber}", headers=headers)
        omim = response.json()
        assert 'omim' in omim, f"Response does not have 'omim' key. {omim}"
        assert len(omim['omim']['entryList']) > 0, f"Response entryList length is 0. {omim}"
        return omim['omim']['entryList'][0]['entry']['titles']['preferredTitle']


def disease_ontology_xref(doid):
    """Retrieve all xrefs for a DOID:XXXX."""
    url = f"https://www.disease-ontology.org/api/metadata/{doid}"
    response = requests.get(url)
    disease = response.json()
    return disease.get('xrefs', None)

def omim_xref(mimNumber):
    """Retrieve all xrefs for a OMIM:XXXX."""
    mimNumber = mimNumber.split(':')[-1]
    headers = {
        "Accept": "application/json",
        "ApiKey": os.environ["OMIM_API_KEY"],
    }
    if mimNumber.startswith('PS'):
        response = requests.get(f"https://api.omim.org/api/entry/search?search=phenotypic_series_number:{mimNumber}&include=externalLinks", headers=headers)
        omim = response.json()
        assert 'omim' in omim, f"Response does not have 'omim' key. {omim}"
    else:
        response = requests.get(f"https://api.omim.org/api/entry?mimNumber={mimNumber}&include=externalLinks", headers=headers)
        omim = response.json()
        assert 'omim' in omim, f"Response does not have 'omim' key. {omim}"
    return omim

# disease_ontology_xrefs = {}
# for key in disease_text:
#     if 'DOID' not in key:
#         continue
#     xrefs = disease_ontology_xref(key)
#     if not xrefs:
#         continue
#     disease_ontology_xrefs[key] = xrefs
# {'DOID:0050589': ['EFO:0003767', 'KEGG:05321', 'MESH:D015212', 'NCI:C3138', 'OMIM:PS266600', 'SNOMEDCT_US_2021_03_01:155759008', 'UMLS_CUI:C0021390'], 'DOID:9744': ['EFO:0001359', 'GARD:10268', 'ICD10CM:E10', 'KEGG:04940', 'MESH:D003922', 'NCI:C2986', 'OMIM:222100', 'SNOMEDCT_US_2021_03_01:46635009', 'UMLS_CUI:C0011854'], 'DOID:1287': ['ICD9CM:429.2', 'MESH:D002318', 'NCI:C2931', 'SNOMEDCT_US_2021_03_01:266275004', 'UMLS_CUI:C0007222'], 'DOID:3393': ['EFO:0001645', 'ICD10CM:I20-I25', 'ICD10CM:I25', 'ICD10CM:I25.10', 'ICD9CM:410-414.99', 'ICD9CM:414.0', 'ICD9CM:414.9', 'MESH:D003324', 'MESH:D003327', 'MESH:D017202', 'NCI:C35505', 'NCI:C50625', 'OMIM:300464', 'OMIM:607339', 'OMIM:608316', 'OMIM:608318', 'OMIM:608320', 'OMIM:610947', 'OMIM:611139', 'OMIM:612030', 'OMIM:614293', 'SNOMEDCT_US_2021_03_01:194852007', 'SNOMEDCT_US_2021_03_01:233822007', 'SNOMEDCT_US_2021_03_01:41702007', 'SNOMEDCT_US_2021_03_01:53741008', 'UMLS_CUI:C0010054', 'UMLS_CUI:C0010068', 'UMLS_CUI:C0151744', 'UMLS_CUI:C0264694'], 'DOID:0060224': ['ICD9CM:427.31', 'MESH:D001281', 'NCI:C50466', 'SNOMEDCT_US_2021_03_01:266306001', 'UMLS_CUI:C0004238'], 'DOID:0014667': ['ICD10CM:E88.9', 'ICD9CM:277.9', 'MESH:D008659', 'NCI:C3235', 'SNOMEDCT_US_2021_03_01:75934005', 'UMLS_CUI:C0025517'], 'DOID:10652': ['EFO:0000249', 'GARD:10254', 'ICD10CM:G30', 'ICD9CM:331.0', 'KEGG:05010', 'MESH:D000544', 'NCI:C2866', 'SNOMEDCT_US_2021_03_01:73768007', 'UMLS_CUI:C0002395'], 'DOID:0060041': ['GARD:10248', 'MESH:D000067877'], 'DOID:2841': ['EFO:0000270', 'GARD:10246', 'ICD10CM:J45', 'ICD9CM:493', 'KEGG:05310', 'MESH:D001249', 'NCI:C28397', 'OMIM:600807', 'SNOMEDCT_US_2021_03_01:187687003', 'UMLS_CUI:C0004096'], 'DOID:5844': ['EFO:0000612', 'ICD10CM:I21', 'MESH:D009203', 'NCI:C27996', 'OMIM:608557', 'SNOMEDCT_US_2021_03_01:66514008', 'UMLS_CUI:C0027051'], 'DOID:1826': ['EFO:0000474', 'ICD10CM:G40.909', 'ICD9CM:345.9', 'MESH:D004827', 'NCI:C3020', 'SNOMEDCT_US_2021_03_01:267698007', 'UMLS_CUI:C0014544'], 'DOID:630': ['MESH:D030342', 'NCI:C3101', 'SNOMEDCT_US_2021_03_01:32895009', 'UMLS_CUI:C0019247'], 'DOID:5419': ['EFO:0000692', 'ICD10CM:F20', 'ICD9CM:295', 'MESH:D012559', 'NCI:C3362', 'OMIM:181500', 'SNOMEDCT_US_2021_03_01:58214004', 'UMLS_CUI:C0036341'], 'DOID:12377': ['GARD:7674', 'ICD10CM:G12.9', 'ICD9CM:335.1', 'MESH:D009134', 'NCI:C85075', 'SNOMEDCT_US_2021_03_01:5262007', 'UMLS_CUI:C0026847']}

#
# wget http://purl.obolibrary.org/obo/mondo/mondo-with-equivalents.json -O  /tmp/mondo-with-equivalents.json
# jq -rc '.graphs[] | .nodes[] | select(.meta.xrefs != null) |   [.id, .meta.definition.val, (.meta.xrefs[] | .val)]  '   /tmp/mondo-with-equivalents.json  > $OUTPUT_PATH/mondo-xrefs.json
#
