# Table of contents

* [About Launchable](README.md)
* [Getting started](getting-started/README.md)
  * [Using the CLI with a public repository](getting-started/integration-for-open-source.md)
* [Sending data to Launchable](sending-data-to-launchable/README.md)
  * [Choosing a value for &lt;BUILD NAME&gt;](sending-data-to-launchable/build-names.md)
  * [Converting test reports to JUnit format](sending-data-to-launchable/convert-to-junit.md)
  * [Ensuring \`record tests\` always runs](sending-data-to-launchable/always-run.md)
  * [Managing complex test session layouts](sending-data-to-launchable/test-sessions.md)
  * [Recording builds from multiple repositories](sending-data-to-launchable/multiple-repositories.md)
  * [Using the generic file-based runner integration](sending-data-to-launchable/file.md)

## 💡Insights

* [Flaky tests](insights/flaky-tests.md)

## 🎛Actions

* [Subsetting your test runs](actions/subsetting-your-test-runs.md)

## 📖Resources

* [CLI reference](resources/cli-reference.md)
* [FAQ](resources/quick-start-faq.md)
* [Guides](resources/guides.md)
* [Integrations](resources/integrations/README.md)
  * [Android Debug Bridge \(adb\)](resources/integrations/adb.md)
  * [Ant](resources/integrations/ant.md)
  * [Bazel](resources/integrations/bazel.md)
  * [Behave](resources/integrations/behave.md)
  * [CTest](resources/integrations/ctest.md)
  * [Cypress](resources/integrations/cypress.md)
  * [GoogleTest](resources/integrations/googletest.md)
  * [Go Test](resources/integrations/go-test.md)
  * [Gradle](resources/integrations/gradle.md)
  * [Maven](resources/integrations/maven.md)
  * [Minitest](resources/integrations/minitest.md)
  * [Nose](resources/integrations/nose.md)
  * [NUnit](resources/integrations/nunit.md)
  * [Pytest](resources/integrations/pytest.md)
  * [Robot](resources/integrations/robot.md)
  * [RSpec](resources/integrations/rspec.md)
* [Supported languages](resources/supported-languages/README.md)
  * [C++](resources/supported-languages/c-plus-plus.md)
  * [.NET](resources/supported-languages/dotnet.md)
  * [Go](resources/supported-languages/go.md)
  * [Java](resources/supported-languages/java.md)
  * [Python](resources/supported-languages/python.md)
  * [Ruby](resources/supported-languages/ruby.md)
* [Troubleshooting](resources/troubleshooting.md)

## 🔒Policies

* [Data privacy and protection](policies/data-privacy-and-protection/README.md)
  * [Data examples](policies/data-privacy-and-protection/data-examples.md)
* [Security policies](policies/information-security.md)

