#
# Pyserini: Reproducible IR research with sparse and dense representations
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

KILT_QUERY_INFO = {
    "fever-dev-kilt": {
        "description": "KILT FEVER dev set",
        "urls": ["http://dl.fbaipublicfiles.com/KILT/fever-dev-kilt.jsonl"],
        "md5": "ae9a27503d177ba82cdb1e968b1aeac1",
        "size (bytes)": 6174139,
        "total_queries": 10444
    },
    "aidayago2-dev-kilt": {
        "description": "KILT AIDA CoNLL-YAGO dev set",
        "urls": ["http://dl.fbaipublicfiles.com/KILT/aidayago2-dev-kilt.jsonl"],
        "md5": "262c2350c0a331b26cdcc70590f068f2",
        "size (bytes)": 21061554,
        "total_queries": 4784
    },
    "wned-dev-kilt": {
        "description": "KILT WNED-WIKI dev set",
        "urls": ["http://dl.fbaipublicfiles.com/KILT/wned-dev-kilt.jsonl"],
        "md5": "b04e18e85c7f87030f5118c21f1297dc",
        "size (bytes)": 12868348,
        "total_queries": 3396
    },
    "cweb-dev-kilt": {
        "description": "KILT WNED-CWEB dev set",
        "urls": ["http://dl.fbaipublicfiles.com/KILT/cweb-dev-kilt.jsonl"],
        "md5": "bb62b9471cdec028abbe91b19030e9ad",
        "size (bytes)": 90228527,
        "total_queries": 5599
    },
    "trex-dev-kilt": {
        "description": "KILT T-REx dev set",
        "urls": ["http://dl.fbaipublicfiles.com/KILT/trex-dev-kilt.jsonl"],
        "md5": "ccd3c43891f08b2d5d9adf3e6885c8f9",
        "size (bytes)": 3803558,
        "total_queries": 5000
    },
    "structured_zeroshot-dev-kilt": {
        "description": "KILT Zero-Shot RE dev set",
        "urls": ["http://dl.fbaipublicfiles.com/KILT/structured_zeroshot-dev-kilt.jsonl"],
        "md5": "b2cb14cb4b00a90352c9ad8317829cfd",
        "size (bytes)": 2266707,
        "total_queries": 3724
    },
    "nq-dev-kilt": {
        "description": "KILT Natural Questions dev set",
        "urls": ["http://dl.fbaipublicfiles.com/KILT/nq-dev-kilt.jsonl"],
        "md5": "0bb57ca0b4676ed66005b8788d3a3050",
        "size (bytes)": 7936566,
        "total_queries": 2837
    },
    "hotpotqa-dev-kilt": {
        "description": "KILT HotpotQA dev set",
        "urls": ["http://dl.fbaipublicfiles.com/KILT/hotpotqa-dev-kilt.jsonl"],
        "md5": "3ebc5eeaa5572ec29451eb4b66c29333",
        "size (bytes)": 3971321,
        "total_queries": 5600
    },
    "triviaqa-dev-kilt": {
        "description": "KILT TriviaQA dev set, generated using KILT's scripts/get_triviaqa_input.py",
        "urls": ["https://github.com/castorini/pyserini-data/raw/main/queries/triviaqa-dev-kilt.jsonl"],
        "md5": "0eda82a7a3e24271d623710fa2a2ff64",
        "size (bytes)": 10314686,
        "total_queries": 5359
    },
    "eli5-dev-kilt": {
        "description": "KILT ELI5 dev set",
        "urls": ["http://dl.fbaipublicfiles.com/KILT/eli5-dev-kilt.jsonl"],
        "md5": "7abac8b2495581d513b0542916178893",
        "size (bytes)": 14149811,
        "total_queries": 1507
    },
    "wow-dev-kilt": {
        "description": "KILT Wizard of Wikipedia dev set",
        "urls": ["http://dl.fbaipublicfiles.com/KILT/wow-dev-kilt.jsonl"],
        "md5": "bf4000198be9d8acbab11a57745a6a8b",
        "size (bytes)": 2418241,
        "total_queries": 3058
    }
}
