"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JavaProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const project_1 = require("../project");
const junit_1 = require("./junit");
const maven_compile_1 = require("./maven-compile");
const maven_packaging_1 = require("./maven-packaging");
const maven_sample_1 = require("./maven-sample");
const pom_1 = require("./pom");
const projenrc_1 = require("./projenrc");
/**
 * (experimental) Java project.
 *
 * @experimental
 * @pjid java
 */
class JavaProject extends project_1.Project {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h;
        super(options);
        this.distdir = (_b = options.distdir) !== null && _b !== void 0 ? _b : 'dist/java';
        this.pom = new pom_1.Pom(this, options);
        if ((_c = options.projenrcJava) !== null && _c !== void 0 ? _c : true) {
            this.projenrc = new projenrc_1.Projenrc(this, this.pom, options.projenrcJavaOptions);
        }
        const sampleJavaPackage = (_d = options.sampleJavaPackage) !== null && _d !== void 0 ? _d : 'org.acme';
        if ((_e = options.junit) !== null && _e !== void 0 ? _e : true) {
            this.junit = new junit_1.Junit(this, {
                pom: this.pom,
                sampleJavaPackage,
                ...options.junitOptions,
            });
        }
        if ((_f = options.sample) !== null && _f !== void 0 ? _f : true) {
            new maven_sample_1.MavenSample(this, { package: sampleJavaPackage });
        }
        // platform independent build
        this.pom.addProperty('project.build.sourceEncoding', 'UTF-8');
        this.gitignore.exclude('.classpath');
        this.gitignore.exclude('.project');
        this.gitignore.exclude('.settings');
        this.compile = new maven_compile_1.MavenCompile(this, this.pom, options.compileOptions);
        this.packaging = new maven_packaging_1.MavenPackaging(this, this.pom, options.packagingOptions);
        this.addPlugin('org.apache.maven.plugins/maven-enforcer-plugin@3.0.0-M3', {
            executions: [{ id: 'enforce-maven', goals: ['enforce'] }],
            configuration: {
                rules: [
                    { requireMavenVersion: [{ version: '3.6' }] },
                ],
            },
        });
        const buildTask = this.addTask('build', { description: 'Full CI build' });
        buildTask.spawn(this.packaging.task);
        for (const dep of (_g = options.deps) !== null && _g !== void 0 ? _g : []) {
            this.addDependency(dep);
        }
        for (const dep of (_h = options.testDeps) !== null && _h !== void 0 ? _h : []) {
            this.addTestDependency(dep);
        }
    }
    /**
     * (experimental) Adds a runtime dependency.
     *
     * @param spec Format `<groupId>/<artifactId>@<semver>`.
     * @experimental
     */
    addDependency(spec) {
        return this.pom.addDependency(spec);
    }
    /**
     * (experimental) Adds a test dependency.
     *
     * @param spec Format `<groupId>/<artifactId>@<semver>`.
     * @experimental
     */
    addTestDependency(spec) {
        return this.pom.addTestDependency(spec);
    }
    /**
     * (experimental) Adds a build plugin to the pom.
     *
     * The plug in is also added as a BUILD dep to the project.
     *
     * @param spec dependency spec (`group/artifact@version`).
     * @param options plugin options.
     * @experimental
     */
    addPlugin(spec, options = {}) {
        return this.pom.addPlugin(spec, options);
    }
}
exports.JavaProject = JavaProject;
_a = JSII_RTTI_SYMBOL_1;
JavaProject[_a] = { fqn: "projen.java.JavaProject", version: "0.17.84" };
//# sourceMappingURL=data:application/json;base64,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