"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const _resolve_1 = require("./_resolve");
const common_1 = require("./common");
const component_1 = require("./component");
const util_1 = require("./util");
/**
 * @experimental
 */
class FileBase extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, filePath, options = {}) {
        var _b, _c, _d, _e, _f, _g;
        super(project);
        if (((_b = options.committed) !== null && _b !== void 0 ? _b : true) && filePath !== '.gitattributes') {
            (_c = project.root.github) === null || _c === void 0 ? void 0 : _c.annotateGenerated(`/${filePath}`);
        }
        this.readonly = (_d = options.readonly) !== null && _d !== void 0 ? _d : true;
        this.executable = (_e = options.executable) !== null && _e !== void 0 ? _e : false;
        this.path = filePath;
        this.absolutePath = path.resolve(project.outdir, filePath);
        // verify file path is unique within project tree
        const existing = project.root.tryFindFile(this.absolutePath);
        if (existing && existing !== this) {
            throw new Error(`there is already a file under ${path.relative(project.root.outdir, this.absolutePath)}`);
        }
        const gitignore = (_f = options.editGitignore) !== null && _f !== void 0 ? _f : true;
        if (gitignore) {
            const committed = (_g = options.committed) !== null && _g !== void 0 ? _g : true;
            const pattern = `/${this.path}`;
            if (committed) {
                project.gitignore.include(pattern);
            }
            else {
                project.gitignore.exclude(pattern);
            }
        }
        else {
            if (options.committed != null) {
                throw new Error('"gitignore" is disabled, so it does not make sense to specify "committed"');
            }
        }
    }
    /**
     * (experimental) Writes the file to the project's output directory.
     *
     * @experimental
     */
    synthesize() {
        const outdir = this.project.outdir;
        const filePath = path.join(outdir, this.path);
        const resolver = { resolve: (obj, options) => _resolve_1.resolve(obj, options) };
        const content = this.synthesizeContent(resolver);
        if (content === undefined) {
            return; // skip
        }
        util_1.writeFile(filePath, content, {
            readonly: this.readonly,
            executable: this.executable,
        });
    }
}
exports.FileBase = FileBase;
_a = JSII_RTTI_SYMBOL_1;
FileBase[_a] = { fqn: "projen.FileBase", version: "0.17.84" };
/**
 * (experimental) The marker to embed in files in order to identify them as projen files.
 *
 * This marker is used to prune these files before synthesis.
 *
 * @experimental
 */
FileBase.PROJEN_MARKER = `${common_1.PROJEN_MARKER}. To modify, edit ${common_1.PROJEN_RC} and run "npx projen".`;
//# sourceMappingURL=data:application/json;base64,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