"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsCdkTypeScriptApp = exports.CdkApprovalLevel = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const fs = require("fs-extra");
const semver = require("semver");
const component_1 = require("./component");
const json_1 = require("./json");
const tasks_1 = require("./tasks");
const typescript_1 = require("./typescript");
/**
 * @experimental
 */
var CdkApprovalLevel;
(function (CdkApprovalLevel) {
    CdkApprovalLevel["NEVER"] = "never";
    CdkApprovalLevel["ANY_CHANGE"] = "any-change";
    CdkApprovalLevel["BROADENING"] = "broadening";
})(CdkApprovalLevel = exports.CdkApprovalLevel || (exports.CdkApprovalLevel = {}));
/**
 * (experimental) AWS CDK app in TypeScript.
 *
 * @experimental
 * @pjid awscdk-app-ts
 */
class AwsCdkTypeScriptApp extends typescript_1.TypeScriptAppProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h;
        super({
            ...options,
            sampleCode: false,
        });
        // encode a hidden assumption further down the chain
        if (this.srcdir !== 'src') {
            throw new Error('sources are expected under the "src" directory');
        }
        // encode a hidden assumption further down the chain
        if (this.testdir !== 'test') {
            throw new Error('test sources are expected under the "test" directory');
        }
        this.appEntrypoint = (_b = options.appEntrypoint) !== null && _b !== void 0 ? _b : 'main.ts';
        this.cdkVersion = options.cdkVersionPinning ? options.cdkVersion : `^${options.cdkVersion}`;
        // CLI
        this.addDevDeps(this.formatModuleSpec('aws-cdk'));
        this.addCdkDependency('@aws-cdk/assert');
        const cdkMajorVersion = (_d = (_c = semver.minVersion(this.cdkVersion)) === null || _c === void 0 ? void 0 : _c.major) !== null && _d !== void 0 ? _d : 1;
        if (cdkMajorVersion < 2) {
            this.addCdkDependency('@aws-cdk/core');
        }
        else {
            this.addCdkDependency('aws-cdk-lib');
            this.addDeps('constructs@^10.0.5');
        }
        this.addCdkDependency(...(_e = options.cdkDependencies) !== null && _e !== void 0 ? _e : []);
        const synth = this.addTask('synth', {
            description: 'Synthesizes your cdk app into cdk.out (part of "yarn build")',
            category: tasks_1.TaskCategory.BUILD,
            exec: 'cdk synth',
        });
        this.addTask('deploy', {
            description: 'Deploys your CDK app to the AWS cloud',
            category: tasks_1.TaskCategory.RELEASE,
            exec: 'cdk deploy',
        });
        this.addTask('destroy', {
            description: 'Destroys your cdk app in the AWS cloud',
            category: tasks_1.TaskCategory.RELEASE,
            exec: 'cdk destroy',
        });
        this.addTask('diff', {
            description: 'Diffs the currently deployed app against your code',
            category: tasks_1.TaskCategory.MISC,
            exec: 'cdk diff',
        });
        // no compile step because we do all of it in typescript directly
        this.compileTask.reset();
        this.removeScript('watch'); // because we use ts-node
        // add synth to the build
        this.buildTask.spawn(synth);
        this.cdkConfig = {
            app: `npx ts-node --prefer-ts-exts ${path.posix.join(this.srcdir, this.appEntrypoint)}`,
        };
        if (options.context) {
            this.cdkConfig.context = { ...options.context };
        }
        if (options.requireApproval) {
            this.cdkConfig.requireApproval = options.requireApproval;
        }
        this.gitignore.exclude('cdk.out/');
        this.gitignore.exclude('.cdk.staging/');
        this.gitignore.exclude('.parcel-cache/');
        (_f = this.npmignore) === null || _f === void 0 ? void 0 : _f.exclude('cdk.out/');
        (_g = this.npmignore) === null || _g === void 0 ? void 0 : _g.exclude('.cdk.staging/');
        if (this.tsconfig) {
            this.tsconfig.exclude.push('cdk.out');
        }
        this.addDevDeps('ts-node');
        new json_1.JsonFile(this, 'cdk.json', {
            obj: this.cdkConfig,
        });
        if ((_h = options.sampleCode) !== null && _h !== void 0 ? _h : true) {
            new SampleCode(this, cdkMajorVersion);
        }
    }
    /**
     * (experimental) Adds an AWS CDK module dependencies.
     *
     * @param modules The list of modules to depend on.
     * @experimental
     */
    addCdkDependency(...modules) {
        if (modules.length === 0) {
            return;
        }
        this.addDeps(...modules.map(m => this.formatModuleSpec(m)));
    }
    formatModuleSpec(module) {
        return `${module}@${this.cdkVersion}`;
    }
}
exports.AwsCdkTypeScriptApp = AwsCdkTypeScriptApp;
_a = JSII_RTTI_SYMBOL_1;
AwsCdkTypeScriptApp[_a] = { fqn: "projen.AwsCdkTypeScriptApp", version: "0.17.84" };
class SampleCode extends component_1.Component {
    constructor(project, cdkMajorVersion) {
        super(project);
        this.cdkMajorVersion = cdkMajorVersion;
        this.appProject = project;
    }
    synthesize() {
        const outdir = this.project.outdir;
        const srcdir = path.join(outdir, this.appProject.srcdir);
        if (fs.pathExistsSync(srcdir) && fs.readdirSync(srcdir).filter(x => x.endsWith('.ts'))) {
            return;
        }
        const srcImports = new Array();
        if (this.cdkMajorVersion < 2) {
            srcImports.push('import { App, Construct, Stack, StackProps } from \'@aws-cdk/core\';');
        }
        else {
            srcImports.push('import { App, Stack, StackProps } from \'aws-cdk-lib\';');
            srcImports.push('import { Construct } from \'constructs\';');
        }
        const srcCode = `${srcImports.join('\n')}

export class MyStack extends Stack {
  constructor(scope: Construct, id: string, props: StackProps = {}) {
    super(scope, id, props);

    // define resources here...
  }
}

// for development, use account/region from cdk cli
const devEnv = {
  account: process.env.CDK_DEFAULT_ACCOUNT,
  region: process.env.CDK_DEFAULT_REGION,
};

const app = new App();

new MyStack(app, 'my-stack-dev', { env: devEnv });
// new MyStack(app, 'my-stack-prod', { env: prodEnv });

app.synth();`;
        fs.mkdirpSync(srcdir);
        fs.writeFileSync(path.join(srcdir, this.appProject.appEntrypoint), srcCode);
        const testdir = path.join(outdir, this.appProject.testdir);
        if (fs.pathExistsSync(testdir) && fs.readdirSync(testdir).filter(x => x.endsWith('.ts'))) {
            return;
        }
        const testImports = new Array();
        if (this.cdkMajorVersion < 2) {
            testImports.push('import { App } from \'@aws-cdk/core\';');
        }
        else {
            testImports.push('import { App } from \'aws-cdk-lib\';');
        }
        const appEntrypointName = path.basename(this.appProject.appEntrypoint, '.ts');
        const testCode = `import '@aws-cdk/assert/jest';
${testImports.join('\n')}
import { MyStack } from '../src/${appEntrypointName}';

test('Snapshot', () => {
  const app = new App();
  const stack = new MyStack(app, 'test');

  expect(stack).not.toHaveResource('AWS::S3::Bucket');
  expect(app.synth().getStackArtifact(stack.artifactId).template).toMatchSnapshot();
});`;
        fs.mkdirpSync(testdir);
        fs.writeFileSync(path.join(testdir, `${appEntrypointName}.test.ts`), testCode);
    }
}
//# sourceMappingURL=data:application/json;base64,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