"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs_extra_1 = require("fs-extra");
const java_project_1 = require("../../java/java-project");
const render_options_1 = require("../../javascript/render-options");
const logger_1 = require("../../logger");
const util_1 = require("../util");
let cwd = process.cwd();
beforeEach(() => process.chdir(util_1.mkdtemp()));
afterEach(() => process.chdir(cwd));
test('defaults', () => {
    const p = new TestJavaProject();
    expect(util_1.synthSnapshot(p)).toMatchSnapshot();
});
test('pom options', () => {
    const p = new TestJavaProject({
        groupId: 'com.myorg',
        artifactId: 'play-202101050157',
    });
    snapPom(p);
});
test('dependencies', () => {
    const p = new TestJavaProject();
    p.pom.addDependency('software.amazon.awscdk/core@^1.2.3');
    p.pom.addTestDependency('org.assertj/assertj-core@3.18.1');
    p.pom.addPlugin('org.apache.maven.plugins/maven-compiler-plugin@3.8.1', {
        configuration: {
            source: '1.8',
            target: '1.8',
        },
    });
    snapPom(p);
});
test('dependencies via ctor', () => {
    const p = new TestJavaProject({
        deps: [
            'software.amazon.awscdk/core@^1.2.3',
            'software.amazon.awscdk/aws-s3@^1',
        ],
        testDeps: [
            'org.assertj/assertj-core@^3',
        ],
    });
    snapPom(p);
});
test('no junit', () => {
    const p = new TestJavaProject({
        junit: false,
    });
    expect(util_1.synthSnapshot(p)).toMatchSnapshot();
});
test('projenrc in java', () => {
    const p = new TestJavaProject();
    expect(util_1.synthSnapshot(p)['src/test/java/projenrc.java']).toMatchSnapshot();
});
test('disable projenrc in java', () => {
    const p = new TestJavaProject({
        projenrcJava: false,
    });
    expect(util_1.synthSnapshot(p)['src/test/java/projenrc.java']).toBeUndefined();
});
function snapPom(p) {
    expect(util_1.synthSnapshot(p)['pom.xml']).toMatchSnapshot();
}
class TestJavaProject extends java_project_1.JavaProject {
    constructor(options = {}) {
        // using a subdirectory to ensure synthSnapshot can clean up the project safely
        fs_extra_1.mkdirpSync('project-dir');
        super(render_options_1.renderProjenNewOptions('projen.java.JavaProject', {
            ...options,
            // not using outdir: mkdtemp() since that will make snapshots non-deterministic
            outdir: './project-dir',
            groupId: 'org.acme',
            artifactId: 'my-artifact',
            name: 'test-project',
            version: '1.0.0',
            logging: { level: logger_1.LogLevel.OFF },
            projenrcJavaOptions: {
                projenVersion: '^1.2.3',
            },
        }));
    }
}
//# sourceMappingURL=data:application/json;base64,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